/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.minecraft;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class SeedWrapper
implements IAgriAdapter<IAgriGenome> {
    @Override
    public boolean accepts(Object obj) {
        if (obj instanceof IItemProvider) {
            return this.accepts(new ItemStack((IItemProvider)obj));
        }
        return obj instanceof ItemStack && this.resolve((ItemStack)obj).isPresent();
    }

    @Override
    public Optional<IAgriGenome> valueOf(Object obj) {
        if (obj instanceof IItemProvider) {
            return this.valueOf(new ItemStack((IItemProvider)obj));
        }
        if (obj instanceof ItemStack) {
            return Objects.requireNonNull(this.resolve((ItemStack)obj));
        }
        return Optional.empty();
    }

    private Optional<IAgriGenome> resolve(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        if (stack.func_77973_b() instanceof ItemDynamicAgriSeed) {
            return ((ItemDynamicAgriSeed)stack.func_77973_b()).getGenome(stack);
        }
        return AgriApi.getPlantRegistry().stream().filter(plant -> this.isSeedItem((IAgriPlant)plant, stack)).findFirst().map(plant -> {
            IAgriGenome genome = AgriApi.getAgriGenomeBuilder(plant).build();
            if (stack.func_77942_o()) {
                assert (stack.func_77978_p() != null);
                genome.readFromNBT(stack.func_77978_p());
            }
            return genome;
        });
    }

    private boolean isSeedItem(IAgriPlant plant, ItemStack seed) {
        return plant.getSeedItems().stream().anyMatch(stack -> ItemStack.func_179545_c((ItemStack)seed, (ItemStack)stack) && this.doTagsMatch(seed, (ItemStack)stack));
    }

    private boolean doTagsMatch(ItemStack seed, ItemStack test) {
        return true;
    }
}

