/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.theoneprobe;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationComponent;
import com.infinityraider.agricraft.reference.AgriToolTips;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

final class AgriProbeIrrigationBlockInfoProvider
implements IProbeInfoProvider {
    private final String id = AgriCraft.instance.getModId() + ":" + "theoneprobe" + "_irrigation";

    protected AgriProbeIrrigationBlockInfoProvider() {
    }

    public String getID() {
        return this.id;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState state, IProbeHitData hitData) {
        this.addIrrigationProbeInfo(info, world, hitData.getPos());
    }

    protected void addIrrigationProbeInfo(IProbeInfo info, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityIrrigationComponent) {
            TileEntityIrrigationChannel channel;
            if (tile instanceof TileEntityIrrigationChannel && (channel = (TileEntityIrrigationChannel)tile).hasValve()) {
                if (channel.isOpen()) {
                    info.text(AgriToolTips.VALVE_INFO_OPEN);
                } else {
                    info.text(AgriToolTips.VALVE_INFO_CLOSED);
                }
            }
            TileEntityIrrigationComponent component = (TileEntityIrrigationComponent)tile;
            info.progress(component.getContent(), component.getCapacity(), (IProgressStyle)new ProgressStyle().filledColor(-13468211).alternateFilledColor(-13159731).suffix(" mB"));
        }
    }
}

