/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.blocks;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationComponent;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.infinityraider.infinitylib.render.tile.ITileRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluids;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class TileEntityIrrigationComponentRenderer<T extends TileEntityIrrigationComponent>
implements ITileRenderer<T>,
IRenderUtilities {
    private static TextureAtlasSprite waterTexture;
    private final Map<IRenderTypeBuffer.Impl, ThreadLocal<ITessellator>> tessellators = Maps.newConcurrentMap();

    protected TileEntityIrrigationComponentRenderer() {
    }

    public void render(T tile, float partialTicks, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            this.renderWater(tile, partialTicks, transforms, (IRenderTypeBuffer.Impl)buffer, light, overlay);
        }
    }

    protected abstract void renderWater(T var1, float var2, MatrixStack var3, IRenderTypeBuffer.Impl var4, int var5, int var6);

    protected ITessellator getTessellator(IRenderTypeBuffer.Impl buffer) {
        return (ITessellator)this.tessellators.computeIfAbsent(buffer, aBuffer -> ThreadLocal.withInitial(() -> this.getVertexBufferTessellator((IRenderTypeBuffer.Impl)aBuffer, this.getRenderType()))).get();
    }

    protected TextureAtlasSprite getWaterTexture() {
        if (waterTexture == null) {
            waterTexture = this.getSprite(Fluids.field_204546_a.getAttributes().getStillTexture());
        }
        return waterTexture;
    }

    protected ITessellator applyWaterColor(T tile, ITessellator tessellator) {
        int color = tile.func_145831_w() == null ? Fluids.field_204546_a.getAttributes().getColor() : Fluids.field_204546_a.getAttributes().getColor((IBlockDisplayReader)tile.func_145831_w(), tile.func_174877_v());
        return tessellator.setColorRGB((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    protected RenderType getRenderType() {
        return RenderType.func_228645_f_();
    }
}

