/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.journal.GeneticsPage;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JournalDataDrawerGenetics
extends JournalDataDrawerBase<GeneticsPage> {
    private final ITextComponent CROP_BREEDING = new TranslationTextComponent("agricraft.journal.crop_breeding");
    private final ITextComponent PARAGRAPH_L_1 = new TranslationTextComponent("agricraft.journal.crop_breeding.paragraph_1");
    private final ITextComponent PARAGRAPH_L_2 = new TranslationTextComponent("agricraft.journal.crop_breeding.paragraph_2");
    private final ITextComponent PARAGRAPH_L_3 = new TranslationTextComponent("agricraft.journal.crop_breeding.paragraph_3");
    private final ResourceLocation DNA_SCHEMATIC = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "textures/journal/dna_schematic.png");
    private final ITextComponent STATS = new TranslationTextComponent("agricraft.journal.stats");
    private final ITextComponent PARAGRAPH_R_1 = new TranslationTextComponent("agricraft.journal.stats.paragraph_1");
    private final ITextComponent PARAGRAPH_GROWTH = new TranslationTextComponent("agricraft.journal.stats.growth");
    private final ITextComponent PARAGRAPH_GAIN = new TranslationTextComponent("agricraft.journal.stats.gain");
    private final ITextComponent PARAGRAPH_STRENGTH = new TranslationTextComponent("agricraft.journal.stats.strength");
    private final ITextComponent PARAGRAPH_RESISTANCE = new TranslationTextComponent("agricraft.journal.stats.resistance");
    private final ITextComponent PARAGRAPH_FERTILITY = new TranslationTextComponent("agricraft.journal.stats.fertility");
    private final ITextComponent PARAGRAPH_MUTATIVITY = new TranslationTextComponent("agricraft.journal.stats.mutativity");

    @Override
    public ResourceLocation getId() {
        return GeneticsPage.INSTANCE.getDataDrawerId();
    }

    @Override
    public void drawLeftSheet(GeneticsPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        float dy = 10.0f;
        float dx = 6.0f;
        float spacing = 4.0f;
        dy += context.drawText(transforms, this.CROP_BREEDING, dx, dy);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_L_1, dx, dy, 0.65f);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_L_2, dx, dy, 0.65f);
        context.draw(transforms, this.DNA_SCHEMATIC, dx, dy += spacing, 96.0f, 32.0f);
        context.drawText(transforms, this.PARAGRAPH_L_3, dx, dy += spacing + 32.0f, 0.65f);
    }

    @Override
    public void drawRightSheet(GeneticsPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        float dy = 10.0f;
        float dx = 6.0f;
        float spacing = 4.0f;
        dy += context.drawText(transforms, this.STATS, dx, dy);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_R_1, dx, dy, 0.65f);
        dy += spacing;
        if (!((Config)AgriCraft.instance.getConfig()).isGrowthStatHidden()) {
            dy += context.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().growthStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
            dy += context.drawText(transforms, this.PARAGRAPH_GROWTH, dx, dy, 0.5f);
            dy += spacing;
        }
        if (!((Config)AgriCraft.instance.getConfig()).isGainStatHidden()) {
            dy += context.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().gainStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
            dy += context.drawText(transforms, this.PARAGRAPH_GAIN, dx, dy, 0.5f);
            dy += spacing;
        }
        if (!((Config)AgriCraft.instance.getConfig()).isStrengthStatHidden()) {
            dy += context.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().strengthStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
            dy += context.drawText(transforms, this.PARAGRAPH_STRENGTH, dx, dy, 0.5f);
            dy += spacing;
        }
        if (!((Config)AgriCraft.instance.getConfig()).isResistanceStatHidden()) {
            dy += context.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().resistanceStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
            dy += context.drawText(transforms, this.PARAGRAPH_RESISTANCE, dx, dy, 0.5f);
            dy += spacing;
        }
        if (!((Config)AgriCraft.instance.getConfig()).isFertilityStatHidden()) {
            dy += context.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().fertilityStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
            dy += context.drawText(transforms, this.PARAGRAPH_FERTILITY, dx, dy, 0.5f);
            dy += spacing;
        }
        if (!((Config)AgriCraft.instance.getConfig()).isMutativityStatHidden()) {
            dy += context.drawText(transforms, (ITextComponent)AgriStatRegistry.getInstance().mutativityStat().getDescription().func_240699_a_(TextFormatting.UNDERLINE), dx, dy, 0.65f);
            context.drawText(transforms, this.PARAGRAPH_MUTATIVITY, dx, dy, 0.5f);
        }
    }
}

