/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.models;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import com.infinityraider.agricraft.impl.v1.plant.AgriPlantRegistry;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class AgriSeedModelLoader
implements InfModelLoader<Geometry> {
    private static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "seed_model_loader");
    private static final ModelOverride MODEL_OVERRIDE = new ModelOverride();
    private static final AgriSeedModelLoader INSTANCE = new AgriSeedModelLoader();
    private final Geometry geometry = new Geometry();

    public static AgriSeedModelLoader getInstance() {
        return INSTANCE;
    }

    private AgriSeedModelLoader() {
    }

    protected Geometry getGeometry() {
        return this.geometry;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public Geometry read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
        return this.getGeometry();
    }

    public static class BakedModel
    implements IBakedModel {
        private final IModelConfiguration owner;

        private BakedModel(IModelConfiguration owner) {
            this.owner = owner;
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.getOverrides().getMissingSprite();
        }

        @Nonnull
        @Deprecated
        public ItemCameraTransforms func_177552_f() {
            return this.owner.getCameraTransforms();
        }

        @Nonnull
        public ModelOverride getOverrides() {
            return MODEL_OVERRIDE;
        }
    }

    public static class ModelOverride
    extends ItemOverrideList
    implements IRenderUtilities {
        protected ModelOverride() {
        }

        @Nullable
        public IBakedModel func_239290_a_(@Nonnull IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            if (stack.func_77973_b() instanceof ItemDynamicAgriSeed) {
                IBakedModel seedModel = this.getModelManager().getModel(((ItemDynamicAgriSeed)stack.func_77973_b()).getPlant(stack).getSeedModel());
                return seedModel.func_188617_f().func_239290_a_(seedModel, stack, world, entity);
            }
            return this.getModelManager().func_174951_a();
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry>,
    IRenderUtilities {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transforms, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new BakedModel(owner);
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            AgriPlantRegistry.getInstance().all().stream().map(IAgriGrowable.WithSeed::getSeedTexture).forEach(rl -> builder.add((Object)new RenderMaterial(this.getTextureAtlasLocation(), rl)));
            return builder.build();
        }
    }
}

