/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.util;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.requirement.RequirementCache;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CropHelper {
    public static boolean rollForWeedAction(IAgriCrop crop) {
        if (((Config)AgriCraft.instance.getConfig()).disableWeeds()) {
            return false;
        }
        World world = crop.world();
        if (world == null) {
            return false;
        }
        if (crop.hasPlant()) {
            int resist = crop.getStats().getResistance();
            int max = AgriStatRegistry.getInstance().resistanceStat().getMax();
            return world.func_201674_k().nextInt(max) >= (max + resist) / 2;
        }
        return world.func_201674_k().nextBoolean();
    }

    public static boolean checkGrowthSpace(World world, BlockPos pos, IAgriGrowable plant, IAgriGrowthStage stage) {
        if (world == null) {
            return false;
        }
        for (double height = plant.getPlantHeight(stage); height > 16.0; height -= 16.0) {
            int offset = (int)height / 16;
            BlockPos up = pos.func_177981_b(offset);
            BlockState state = world.func_180495_p(up);
            if (state.func_177230_c().isAir(state, (IBlockReader)world, up)) continue;
            return false;
        }
        return true;
    }

    public static void spawnWeeds(IAgriCrop crop) {
        World world = crop.world();
        if (world == null) {
            return;
        }
        AgriApi.getWeedRegistry().stream().filter(IAgriWeed::isWeed).filter(weed -> world.func_201674_k().nextDouble() < weed.spawnChance(crop)).findAny().ifPresent(weed -> crop.setWeed((IAgriWeed)weed, weed.getInitialGrowthStage()));
    }

    public static void spreadWeeds(IAgriCrop crop) {
        if (((Config)AgriCraft.instance.getConfig()).allowAggressiveWeeds() && crop.getWeeds().isAggressive()) {
            crop.streamNeighbours().filter(IAgriCrop::isValid).filter(nb -> !nb.hasWeeds()).filter(CropHelper::rollForWeedAction).forEach(nb -> nb.setWeed(crop.getWeeds(), crop.getWeeds().getInitialGrowthStage()));
        }
    }

    public static void executePlantHarvestRolls(IAgriCrop crop, @Nonnull Consumer<ItemStack> consumer) {
        World world = crop.world();
        if (world == null) {
            return;
        }
        for (int trials = (crop.getStats().getGain() + 3) / 3; trials > 0; --trials) {
            crop.getPlant().getHarvestProducts(consumer, crop.getGrowthStage(), crop.getStats(), world.func_201674_k());
        }
    }

    public static void addDisplayInfo(IAgriCrop crop, RequirementCache requirement, @Nonnull Consumer<ITextComponent> consumer) {
        Preconditions.checkNotNull(consumer);
        if (crop.hasPlant()) {
            consumer.accept(AgriToolTips.getPlantTooltip(crop.getPlant()));
            consumer.accept(AgriToolTips.getGrowthTooltip(crop.getGrowthStage(), crop.getGrowthPercentage()));
            crop.getStats().addTooltips(consumer);
            requirement.addTooltip(consumer);
        } else {
            consumer.accept(AgriToolTips.NO_PLANT);
        }
        if (crop.hasWeeds()) {
            consumer.accept(AgriToolTips.getWeedTooltip(crop.getWeeds()));
            consumer.accept(AgriToolTips.getWeedGrowthTooltip(crop.getWeedGrowthPercentage()));
        } else {
            consumer.accept(AgriToolTips.NO_WEED);
        }
        crop.getSoil().map(soil -> {
            consumer.accept(AgriToolTips.getSoilTooltip(soil));
            return true;
        }).orElseGet(() -> {
            consumer.accept(AgriToolTips.getUnknownTooltip(AgriToolTips.SOIL));
            return false;
        });
    }

    public static void playPlantingSound(World world, BlockPos pos, @Nullable PlayerEntity player) {
        SoundType sound = Blocks.field_150464_aj.func_220072_p(Blocks.field_150464_aj.func_176223_P());
        world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
    }
}

