/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.util;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class TagUtil {
    public static final boolean isValidTag(@Nonnull ITagCollection<?> registry, @Nullable String element) {
        if (element == null || element.isEmpty()) {
            return false;
        }
        String[] parts = element.split(":");
        if (parts.length == 1) {
            return TagUtil.isValidTag(registry, "minecraft", parts[0]);
        }
        if (parts.length == 2) {
            return TagUtil.isValidTag(registry, parts[0], parts[1]);
        }
        if (parts.length > 2) {
            AgriCore.getLogger("agricraft").warn("Invalid stack identifier detected!\n\tGiven: \"{0}\"\n\tAssuming: \"{1}:{2}\"", element, parts[0], parts[1]);
            return TagUtil.isValidTag(registry, parts[0], parts[1]);
        }
        throw new AssertionError((Object)"String.split() method worked incorrectly. This should be an impossible error.");
    }

    public static final boolean isValidTag(@Nonnull ITagCollection<?> registry, @Nonnull String prefix, @Nonnull String suffix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A stack identifier must have a non-null prefix!");
        Preconditions.checkNotNull((Object)suffix, (Object)"A stack identifier must have a non-null suffix!");
        if (!registry.func_199908_a().contains(new ResourceLocation(prefix, suffix))) {
            AgriCore.getLogger("agricraft").error("Unable to resolve Item Tag Entry: \"{0}:{1}\".", prefix, suffix);
            return false;
        }
        return true;
    }

    @Nonnull
    public static Optional<ItemStack> getFirstStack(@Nonnull ITagCollection<Item> registry, @Nonnull ResourceLocation id) {
        return Optional.ofNullable(registry.func_199910_a(id)).flatMap(tag -> tag.func_230236_b_().stream().findFirst()).flatMap(obj -> TagUtil.createStackFromObject(obj, 1));
    }

    private static Optional<ItemStack> createStackFromObject(Object object, int amount) {
        if (object instanceof IItemProvider) {
            return Optional.of(new ItemStack((IItemProvider)object, amount));
        }
        return Optional.empty();
    }

    @Nonnull
    public static final Collection<ItemStack> fetchItemStacks(@Nullable String element, int amount, boolean useTags, String data, List<String> ignoredData) {
        if (element == null || element.isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = element.split(":");
        if (parts.length == 1) {
            return TagUtil.fetchItemStacks("minecraft", parts[0], amount, useTags, data, ignoredData);
        }
        if (parts.length == 2) {
            return TagUtil.fetchItemStacks(parts[0], parts[1], amount, useTags, data, ignoredData);
        }
        if (parts.length > 2) {
            AgriCore.getLogger("agricraft").warn("Invalid stack identifier detected!\n\tGiven: \"{0}\"\n\tAssuming: \"{1}:{2}\"", element, parts[0], parts[1]);
            return TagUtil.fetchItemStacks(parts[0], parts[1], amount, useTags, data, ignoredData);
        }
        throw new AssertionError((Object)"String.split() method worked incorrectly. This should be an impossible error.");
    }

    @Nonnull
    public static final Collection<ItemStack> fetchItemStacks(@Nonnull String prefix, @Nonnull String suffix, int amount, boolean useTags, String data, List<String> ignoredData) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A stack identifier must have a non-null prefix!");
        Preconditions.checkNotNull((Object)suffix, (Object)"A stack identifier must have a non-null suffix!");
        if (useTags) {
            return TagUtil.makeItemStackFromTag(prefix, suffix, amount, data, ignoredData);
        }
        return TagUtil.makeItemStackNormal(prefix, suffix, amount, data, ignoredData);
    }

    @Nonnull
    private static Collection<ItemStack> makeItemStackNormal(@Nonnull String prefix, @Nonnull String suffix, int amount, String data, List<String> ignoredData) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(prefix, suffix));
        if (item == null) {
            AgriCore.getLogger("agricraft").error("Unable to resolve item: {0}:{1}.", prefix, suffix);
            return Collections.emptyList();
        }
        ItemStack stack = new ItemStack((IItemProvider)item, amount);
        return (Collection)TagUtil.addNbtData(stack, data).map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Nonnull
    private static Collection<ItemStack> makeItemStackFromTag(@Nonnull String prefix, @Nonnull String suffix, int amount, String data, List<String> ignoredData) {
        return Optional.ofNullable(TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(prefix, suffix))).map(tag -> tag.func_230236_b_().stream().map(item -> TagUtil.addNbtData(new ItemStack((IItemProvider)item, amount), data)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Nonnull
    private static Optional<ItemStack> addNbtData(@Nonnull ItemStack stack, @Nullable String tags) {
        Preconditions.checkNotNull((Object)stack, (Object)"The itemstack to add NBT data to may not be null");
        if (Strings.isNullOrEmpty((String)tags)) {
            return Optional.of(stack);
        }
        CompoundNBT tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        try {
            CompoundNBT added = JsonToNBT.func_180713_a((String)tags);
            tag.func_197643_a(added);
            stack.func_77982_d(tag);
            return Optional.of(stack);
        }
        catch (CommandSyntaxException e) {
            AgriCore.getLogger("agricraft").error("Unable to parse NBT Data: \"{0}\".\nCause: {1}", new Object[]{tags, e});
            return Optional.empty();
        }
    }

    @Nonnull
    public static final Collection<BlockState> fetchBlockStates(@Nullable String element, boolean useTags, String data, List<String> ignoredData) {
        if (element == null || element.isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = element.split(":");
        if (parts.length == 1) {
            return TagUtil.fetchBlockStates("minecraft", parts[0], useTags, data, ignoredData);
        }
        if (parts.length == 2) {
            return TagUtil.fetchBlockStates(parts[0], parts[1], useTags, data, ignoredData);
        }
        if (parts.length > 2) {
            AgriCore.getLogger("agricraft").warn("Invalid stack identifier detected!\n\tGiven: \"{0}\"\n\tAssuming: \"{1}:{2}\"", element, parts[0], parts[1]);
            return TagUtil.fetchBlockStates(parts[0], parts[1], useTags, data, ignoredData);
        }
        throw new AssertionError((Object)"String.split() method worked incorrectly. This should be an impossible error.");
    }

    @Nonnull
    public static final Collection<BlockState> fetchBlockStates(@Nonnull String prefix, @Nonnull String suffix, boolean useTags, @Nullable String data, List<String> ignoredData) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A Block identifier must have a non-null prefix!");
        Preconditions.checkNotNull((Object)suffix, (Object)"A Block identifier must have a non-null suffix!");
        if (useTags) {
            return TagUtil.fetchBlockStatesFromTag(prefix, suffix, data, ignoredData);
        }
        return TagUtil.fetchBlockStatesNormal(prefix, suffix, data, ignoredData);
    }

    @Nonnull
    private static Collection<BlockState> fetchBlockStatesNormal(@Nonnull String prefix, @Nonnull String suffix, @Nullable String data, List<String> ignoredData) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(prefix, suffix));
        if (block == null) {
            AgriCore.getLogger("agricraft").error("Unable to resolve block: {0}:{1}.", prefix, suffix);
            return Collections.emptyList();
        }
        return block.func_176194_O().func_177619_a();
    }

    @Nonnull
    private static Collection<BlockState> fetchBlockStatesFromTag(@Nonnull String prefix, @Nonnull String suffix, @Nullable String data, List<String> ignoredData) {
        return Optional.ofNullable(TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(prefix, suffix))).map(tag -> tag.func_230236_b_().stream().flatMap(block -> block.func_176194_O().func_177619_a().stream()).filter(state -> true).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Nonnull
    public static final Collection<FluidState> fetchFluidStates(@Nullable String element, boolean useTags, String data, List<String> ignoredData) {
        if (element == null || element.isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = element.split(":");
        if (parts.length == 1) {
            return TagUtil.fetchFluidStates("minecraft", parts[0], useTags, data, ignoredData);
        }
        if (parts.length == 2) {
            return TagUtil.fetchFluidStates(parts[0], parts[1], useTags, data, ignoredData);
        }
        if (parts.length > 2) {
            AgriCore.getLogger("agricraft").warn("Invalid stack identifier detected!\n\tGiven: \"{0}\"\n\tAssuming: \"{1}:{2}\"", element, parts[0], parts[1]);
            return TagUtil.fetchFluidStates(parts[0], parts[1], useTags, data, ignoredData);
        }
        throw new AssertionError((Object)"String.split() method worked incorrectly. This should be an impossible error.");
    }

    @Nonnull
    public static final Collection<FluidState> fetchFluidStates(@Nonnull String prefix, @Nonnull String suffix, boolean useTags, @Nullable String data, List<String> ignoredData) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A Fluid identifier must have a non-null prefix!");
        Preconditions.checkNotNull((Object)suffix, (Object)"A Fluid identifier must have a non-null suffix!");
        if (useTags) {
            return TagUtil.fetchFluidStatesFromTag(prefix, suffix, data, ignoredData);
        }
        return TagUtil.fetchFluidStatesNormal(prefix, suffix, data, ignoredData);
    }

    @Nonnull
    private static Collection<FluidState> fetchFluidStatesNormal(@Nonnull String prefix, @Nonnull String suffix, @Nullable String data, List<String> ignoredData) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(prefix, suffix));
        if (fluid == null) {
            AgriCore.getLogger("agricraft").error("Unable to resolve block: {0}:{1}.", prefix, suffix);
            return Collections.emptyList();
        }
        return fluid.func_207182_e().func_177619_a();
    }

    @Nonnull
    private static Collection<FluidState> fetchFluidStatesFromTag(@Nonnull String prefix, @Nonnull String suffix, @Nullable String data, List<String> ignoredData) {
        return Optional.ofNullable(TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(new ResourceLocation(prefix, suffix))).map(tag -> tag.func_230236_b_().stream().flatMap(fluid -> fluid.func_207182_e().func_177619_a().stream()).filter(state -> true).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private TagUtil() {
    }
}

