/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.WirelessChargersClient;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChargerBlock
extends BaseBlock
implements EntityHoldingBlock,
IWaterLoggable {
    public final ChargerType type;

    public ChargerBlock(ChargerType type) {
        super(true, BlockProperties.create((Material)Material.field_151573_f, (DyeColor)DyeColor.GRAY).destroyTime(2.0f).explosionResistance(2.0f));
        this.type = type;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.type.modelType.outlineShape.getUnderlying();
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return this.type.modelType.collisionShape.getUnderlying();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public TileEntity createNewBlockEntity() {
        return this.type.createBlockEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, Direction hitSide, Vector3d hitLocation) {
        if (level.field_72995_K) {
            WirelessChargersClient.openChargerScreen((ITextComponent)TextComponents.block((Block)this).get(), level, pos);
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    protected void appendItemInformation(ItemStack stack, IBlockReader level, Consumer<ITextComponent> info, boolean advanced) {
        int redstoneMode;
        int energy;
        IFormattableTextComponent transferRate;
        IFormattableTextComponent range = TextComponents.number((int)(this.type.range.get() * 2 + 1)).color(TextFormatting.GOLD).get();
        if (this.type.canChargeBlocks) {
            info.accept((ITextComponent)TextComponents.translation((String)"wirelesschargers.charger.info.blocks", (Object[])new Object[]{range}).color(TextFormatting.YELLOW).get());
            transferRate = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.transferRate.get())).color(TextFormatting.GOLD).string(" " + EnergyFormat.formatUnitPerTick()).color(TextFormatting.GRAY).get();
            info.accept((ITextComponent)TextComponents.translation((String)"wirelesschargers.charger.info.transfer_rate_blocks", (Object[])new Object[]{transferRate}).color(TextFormatting.GRAY).get());
        }
        if (this.type.canChargePlayers) {
            info.accept((ITextComponent)TextComponents.translation((String)"wirelesschargers.charger.info.players", (Object[])new Object[]{range}).color(TextFormatting.YELLOW).get());
            transferRate = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.transferRate.get())).color(TextFormatting.GOLD).string(" " + EnergyFormat.formatUnitPerTick()).color(TextFormatting.GRAY).get();
            info.accept((ITextComponent)TextComponents.translation((String)"wirelesschargers.charger.info.transfer_rate_players", (Object[])new Object[]{transferRate}).color(TextFormatting.GRAY).get());
        }
        int n = energy = stack.func_77978_p() == null ? 0 : stack.func_77978_p().func_74775_l("tileData").func_74762_e("energy");
        if (energy > 0) {
            IFormattableTextComponent energyText = TextComponents.string((String)EnergyFormat.formatEnergy((int)energy)).color(TextFormatting.GOLD).get();
            IFormattableTextComponent capacity = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.capacity.get())).color(TextFormatting.GOLD).string(" " + EnergyFormat.formatUnit()).color(TextFormatting.GRAY).get();
            info.accept((ITextComponent)TextComponents.translation((String)"wirelesschargers.charger.info.stored_energy", (Object[])new Object[]{energyText, capacity}).color(TextFormatting.GRAY).get());
        }
        int n2 = stack.func_77978_p() == null ? 2 : (redstoneMode = stack.func_77978_p().func_74775_l("tileData").func_74764_b("redstoneMode") ? stack.func_77978_p().func_74775_l("tileData").func_74762_e("redstoneMode") : 2);
        if (redstoneMode != 2) {
            ChargerBlockEntity.RedstoneMode mode = ChargerBlockEntity.RedstoneMode.fromIndex(redstoneMode);
            IFormattableTextComponent value = TextComponents.translation((String)("wirelesschargers.screen.redstone_" + mode.name().toLowerCase(Locale.ROOT))).color(TextFormatting.GOLD).get();
            info.accept((ITextComponent)TextComponents.translation((String)"wirelesschargers.charger.info.redstone_mode", (Object[])new Object[]{value}).color(TextFormatting.GRAY).get());
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return direction != Direction.UP;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof ChargerBlockEntity) {
            ((ChargerBlockEntity)entity).setRedstonePowered(world.func_175640_z(pos));
        }
    }
}

