/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.compat.ModCompatibility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ChargerBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int SEARCH_BLOCKS_PER_TICK = 5;
    private static final Set<Direction> CAPABILITY_DIRECTIONS;
    private final LazyOptional<IEnergyStorage> capability = LazyOptional.of(() -> this);
    public final ChargerType field_200663_e;
    private int energy;
    private boolean highlightArea;
    private RedstoneMode redstoneMode = RedstoneMode.DISABLED;
    private boolean isRedstonePowered;
    private int blockSearchX;
    private int blockSearchY;
    private int blockSearchZ;
    private final Map<BlockPos, Direction> chargeableBlocks = new LinkedHashMap<BlockPos, Direction>();
    public int renderingTickCount = 0;
    public float renderingRotationSpeed;
    public float renderingRotation;

    public ChargerBlockEntity(ChargerType type) {
        super(type.getBlockEntityType());
        this.field_200663_e = type;
    }

    public void update() {
        if (this.field_145850_b.field_72995_K) {
            ++this.renderingTickCount;
            if (!this.redstoneMode.canOperate(this.isRedstonePowered)) {
                this.renderingRotationSpeed = Math.max(0.0f, this.renderingRotationSpeed - 0.02f);
                this.renderingRotation += this.renderingRotationSpeed;
                return;
            }
            this.renderingRotationSpeed = Math.min(this.renderingRotationSpeed + 0.02f, this.getEnergyFillPercentage());
            this.renderingRotation += this.renderingRotationSpeed;
        } else {
            boolean spawnParticles = false;
            if (this.field_200663_e.canChargeBlocks) {
                for (int i = 0; i < 5; ++i) {
                    BlockPos offset = new BlockPos(this.blockSearchX, this.blockSearchY, this.blockSearchZ);
                    BlockPos blockPos = this.field_174879_c.func_177971_a((Vector3i)offset);
                    if (!blockPos.equals((Object)this.field_174879_c)) {
                        TileEntity entity = this.field_145850_b.func_175625_s(blockPos);
                        boolean canAcceptEnergy = false;
                        for (Direction direction : CAPABILITY_DIRECTIONS) {
                            if (entity == null || entity instanceof ChargerBlockEntity || !entity.getCapability(CapabilityEnergy.ENERGY, direction).map(IEnergyStorage::canReceive).orElse(false).booleanValue()) continue;
                            this.chargeableBlocks.put(offset, direction);
                            canAcceptEnergy = true;
                            break;
                        }
                        if (!canAcceptEnergy) {
                            this.chargeableBlocks.remove(offset);
                        }
                    }
                    int range = this.field_200663_e.range.get();
                    ++this.blockSearchX;
                    if (this.blockSearchX <= range) continue;
                    this.blockSearchX = -range;
                    ++this.blockSearchZ;
                    if (this.blockSearchZ <= range) continue;
                    this.blockSearchZ = -range;
                    ++this.blockSearchY;
                    if (this.blockSearchY <= range) continue;
                    this.blockSearchY = -range;
                }
                if (this.energy > 0) {
                    HashSet<Object> toRemove = new HashSet<Object>();
                    for (Map.Entry<Object, Object> entry : this.chargeableBlocks.entrySet()) {
                        LazyOptional optional;
                        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)entry.getKey()));
                        if (tile != null && (optional = tile.getCapability(CapabilityEnergy.ENERGY, (Direction)entry.getValue())).isPresent()) {
                            int toTransfer = Math.min(this.energy, this.field_200663_e.transferRate.get());
                            int transferred = optional.map(storage -> storage.receiveEnergy(toTransfer, false)).orElse(0);
                            if (transferred <= 0) continue;
                            spawnParticles = true;
                            this.energy -= transferred;
                            this.dataChanged();
                            if (this.energy > 0) continue;
                            break;
                        }
                        toRemove.add(entry.getKey());
                    }
                    toRemove.forEach(this.chargeableBlocks::remove);
                }
            }
            if (this.field_200663_e.canChargePlayers && this.energy > 0) {
                List players = this.field_145850_b.func_217357_a(PlayerEntity.class, this.getOperatingArea());
                block3: for (PlayerEntity playerEntity : players) {
                    int toTransfer = Math.min(this.energy, this.field_200663_e.transferRate.get());
                    IItemHandlerModifiable handler = ModCompatibility.curios.getCuriosStacks(playerEntity);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        int max;
                        LazyOptional optional;
                        int transferred;
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.func_190926_b() || (transferred = (optional = stack.getCapability(CapabilityEnergy.ENERGY)).map(arg_0 -> ChargerBlockEntity.lambda$update$2(max = toTransfer, arg_0)).orElse(0).intValue()) <= 0) continue;
                        handler.setStackInSlot(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block3;
                        if ((toTransfer -= transferred) <= 0) continue block3;
                    }
                    PlayerInventory inventory = playerEntity.field_71071_by;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        int max;
                        LazyOptional optional;
                        int transferred;
                        ItemStack stack = inventory.func_70301_a(i);
                        if (stack.func_190926_b() || (transferred = (optional = stack.getCapability(CapabilityEnergy.ENERGY)).map(arg_0 -> ChargerBlockEntity.lambda$update$3(max = toTransfer, arg_0)).orElse(0).intValue()) <= 0) continue;
                        inventory.func_70299_a(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block3;
                        if ((toTransfer -= transferred) <= 0) continue block3;
                    }
                }
            }
            if (spawnParticles && this.field_145850_b instanceof ServerWorld && this.field_145850_b.func_201674_k().nextDouble() <= (double)this.getEnergyFillPercentage()) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)this.field_145850_b.func_201674_k().nextFloat() * 0.8 - 0.4;
                double d = (double)this.field_174879_c.func_177956_o() + 0.7 + (double)this.field_145850_b.func_201674_k().nextFloat() * 0.8 - 0.4;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)this.field_145850_b.func_201674_k().nextFloat() * 0.8 - 0.4;
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, x, d, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getEnergyFillPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.energy / (float)this.field_200663_e.capacity.get().intValue()));
    }

    public AxisAlignedBB getOperatingArea() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.field_200663_e.range.get().intValue());
    }

    public void setRedstonePowered(boolean powered) {
        if (this.isRedstonePowered != powered) {
            this.isRedstonePowered = powered;
            this.dataChanged();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex((this.redstoneMode.index + 1) % RedstoneMode.values().length);
        this.dataChanged();
    }

    public boolean isAreaHighlighted() {
        return this.highlightArea;
    }

    public void toggleHighlightArea() {
        this.highlightArea = !this.highlightArea;
        this.dataChanged();
    }

    protected CompoundNBT writeData() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("energy", this.energy);
        compound.func_74757_a("highlightArea", this.highlightArea);
        compound.func_74768_a("redstoneMode", this.redstoneMode.index);
        compound.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        if (this.field_200663_e.canChargeBlocks) {
            compound.func_74768_a("blockSearchX", this.blockSearchX);
            compound.func_74768_a("blockSearchY", this.blockSearchX);
            compound.func_74768_a("blockSearchZ", this.blockSearchX);
            int[] arr = new int[this.chargeableBlocks.size() * 4];
            int index = 0;
            for (Map.Entry<BlockPos, Direction> entry : this.chargeableBlocks.entrySet()) {
                arr[index] = entry.getKey().func_177958_n();
                arr[index + 1] = entry.getKey().func_177956_o();
                arr[index + 2] = entry.getKey().func_177952_p();
                arr[index + 3] = entry.getValue() == null ? -1 : entry.getValue().func_176745_a();
                ++index;
            }
            compound.func_74783_a("chargeableBlocks", arr);
        }
        return compound;
    }

    public CompoundNBT writeItemStackData() {
        CompoundNBT compound = this.writeData();
        if (compound.func_74762_e("energy") <= 0 && compound.func_74762_e("redstoneMode") == 2) {
            return null;
        }
        compound.func_82580_o("highlightArea");
        compound.func_82580_o("isRedstonePowered");
        if (this.field_200663_e.canChargeBlocks) {
            compound.func_82580_o("blockSearchX");
            compound.func_82580_o("blockSearchY");
            compound.func_82580_o("blockSearchZ");
            compound.func_82580_o("chargeableBlocks");
        }
        return compound;
    }

    protected void readData(CompoundNBT compound) {
        this.energy = compound.func_74762_e("energy");
        this.highlightArea = compound.func_74767_n("highlightArea");
        this.redstoneMode = RedstoneMode.fromIndex(compound.func_74762_e("redstoneMode"));
        this.isRedstonePowered = compound.func_74767_n("isRedstonePowered");
        if (this.field_200663_e.canChargeBlocks && compound.func_74764_b("chargeableBlocks")) {
            this.blockSearchX = compound.func_74762_e("blockSearchX");
            this.blockSearchY = compound.func_74762_e("blockSearchY");
            this.blockSearchZ = compound.func_74762_e("blockSearchZ");
            int[] arr = compound.func_74759_k("chargeableBlocks");
            this.chargeableBlocks.clear();
            for (int i = 0; i < arr.length / 4; ++i) {
                this.chargeableBlocks.put(new BlockPos(arr[i], arr[i + 1], arr[i + 2]), arr[i + 3] == -1 ? null : Direction.func_82600_a((int)arr[i + 3]));
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side != Direction.UP) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(maxReceive, Math.min(this.field_200663_e.capacity.get() - this.energy, this.field_200663_e.transferRate.get() * 100));
        if (!simulate) {
            this.energy += received;
            this.dataChanged();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.field_200663_e.capacity.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public void onChunkUnloaded() {
        this.capability.invalidate();
        super.onChunkUnloaded();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.highlightArea ? this.getOperatingArea() : new AxisAlignedBB(this.field_174879_c);
    }

    private static /* synthetic */ Integer lambda$update$3(int max, IEnergyStorage storage) {
        return storage.receiveEnergy(max, false);
    }

    private static /* synthetic */ Integer lambda$update$2(int max, IEnergyStorage storage) {
        return storage.receiveEnergy(max, false);
    }

    static {
        HashSet<Direction> directions = new HashSet<Direction>();
        directions.add(null);
        directions.addAll(Arrays.asList(Direction.values()));
        CAPABILITY_DIRECTIONS = Collections.unmodifiableSet(directions);
    }

    public static enum RedstoneMode {
        HIGH(0),
        LOW(1),
        DISABLED(2);

        public final int index;

        private RedstoneMode(int index) {
            this.index = index;
        }

        public boolean canOperate(boolean isPowered) {
            return this == DISABLED || (isPowered ? this == HIGH : this == LOW);
        }

        public static RedstoneMode fromIndex(int index) {
            for (RedstoneMode mode : RedstoneMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }
}

