/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseTileBlock;
import appeng.helpers.AEMaterials;
import appeng.helpers.MetaRotation;
import appeng.tile.misc.LightDetectorTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LightDetectorBlock
extends AEBaseTileBlock<LightDetectorTileEntity>
implements IOrientableBlock {
    public static final BooleanProperty ODD = BooleanProperty.func_177716_a((String)"odd");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public LightDetectorBlock() {
        super(LightDetectorBlock.defaultProps(AEMaterials.FIXTURE).func_200942_a().func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP)).func_206870_a((Property)ODD, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H});
        builder.func_206894_a(new Property[]{ODD});
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public int func_180656_a(BlockState state, IBlockReader w, BlockPos pos, Direction side) {
        if (w instanceof World && ((LightDetectorTileEntity)this.getTileEntity(w, pos)).isReady()) {
            return ((World)w).func_201696_r(pos) - 6;
        }
        return 0;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        LightDetectorTileEntity tld = (LightDetectorTileEntity)this.getTileEntity((IBlockReader)world, pos);
        if (tld != null) {
            tld.updateLight();
        }
    }

    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
    }

    @Override
    public boolean isValidOrientation(IWorld w, BlockPos pos, Direction forward, Direction up) {
        return this.canPlaceAt((IBlockReader)w, pos, up.func_176734_d());
    }

    private boolean canPlaceAt(IBlockReader w, BlockPos pos, Direction dir) {
        BlockPos test = pos.func_177972_a(dir);
        BlockState blockstate = w.func_180495_p(test);
        return blockstate.func_224755_d(w, test, dir.func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        Direction up = this.getOrientable(w, pos).getUp();
        double xOff = -0.3 * (double)up.func_82601_c();
        double yOff = -0.3 * (double)up.func_96559_d();
        double zOff = -0.3 * (double)up.func_82599_e();
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction up = this.getOrientable((IBlockReader)world, pos).getUp();
        if (!this.canPlaceAt((IBlockReader)world, pos, up.func_176734_d())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(World w, BlockPos pos) {
        BlockState prev = w.func_180495_p(pos);
        w.func_175655_b(pos, true);
        w.func_184138_a(pos, prev, w.func_180495_p(pos), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader w, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.canPlaceAt((IBlockReader)w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOrientable getOrientable(IBlockReader w, BlockPos pos) {
        return new MetaRotation(w, pos, (Property<Direction>)BlockStateProperties.field_208155_H);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        FluidState fluidState = context.func_195991_k().func_204610_c(pos);
        BlockState blockState = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        return blockState;
    }

    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }
}

