/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.storage.cells.CellState;
import appeng.block.storage.DriveSlotState;
import com.google.common.base.Preconditions;
import net.minecraft.item.Item;

public class DriveSlotsState {
    private final Item[] cells;
    private final DriveSlotState[] states;

    public DriveSlotsState(Item[] cells, DriveSlotState[] states) {
        Preconditions.checkArgument((cells.length == states.length ? 1 : 0) != 0);
        this.cells = cells;
        this.states = states;
    }

    public DriveSlotState getState(int index) {
        if (index >= this.states.length) {
            return DriveSlotState.EMPTY;
        }
        return this.states[index];
    }

    public Item getCell(int index) {
        if (index >= this.cells.length) {
            return null;
        }
        return this.cells[index];
    }

    public int getSlotCount() {
        return this.cells.length;
    }

    public static DriveSlotsState fromChestOrDrive(IChestOrDrive chestOrDrive) {
        DriveSlotState[] states = new DriveSlotState[chestOrDrive.getCellCount()];
        Item[] cells = new Item[chestOrDrive.getCellCount()];
        for (int i = 0; i < chestOrDrive.getCellCount(); ++i) {
            cells[i] = chestOrDrive.getCellItem(i);
            if (!chestOrDrive.isPowered()) {
                if (chestOrDrive.getCellStatus(i) != CellState.EMPTY) {
                    states[i] = DriveSlotState.OFFLINE;
                    continue;
                }
                states[i] = DriveSlotState.EMPTY;
                continue;
            }
            states[i] = DriveSlotState.fromCellStatus(chestOrDrive.getCellStatus(i));
        }
        return new DriveSlotsState(cells, states);
    }

    public static DriveSlotsState createEmpty(int slotCount) {
        DriveSlotState[] states = new DriveSlotState[slotCount];
        Item[] cells = new Item[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            states[i] = DriveSlotState.EMPTY;
        }
        return new DriveSlotsState(cells, states);
    }
}

