/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.client.Point;
import appeng.client.gui.IIngredientSupplier;
import appeng.client.gui.Icon;
import appeng.client.gui.TextOverride;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.layout.SlotGridLayout;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.SlotPosition;
import appeng.client.gui.style.Text;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.client.gui.widgets.ITickingWidget;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.VerticalButtonBar;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.container.slot.DisabledSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlot;
import appeng.container.slot.PatternTermSlot;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.SwapSlotsPacket;
import appeng.helpers.InventoryAction;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;

public abstract class AEBaseScreen<T extends AEBaseContainer>
extends ContainerScreen<T> {
    private static final Point HIDDEN_SLOT_POS = new Point(-9999, -9999);
    public static final String TEXT_ID_DIALOG_TITLE = "dialog_title";
    private final VerticalButtonBar verticalToolbar;
    private final Set<Slot> drag_click = new HashSet<Slot>();
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private ItemStack dbl_whichItem = ItemStack.field_190927_a;
    private Slot bl_clicked;
    private boolean handlingRightClick;
    private final List<CustomSlotWidget> guiSlots = new ArrayList<CustomSlotWidget>();
    private final ArrayListMultimap<SlotSemantic, CustomSlotWidget> guiSlotsBySemantic = ArrayListMultimap.create();
    private final Map<String, TextOverride> textOverrides = new HashMap<String, TextOverride>();
    private final EnumSet<SlotSemantic> hiddenSlots = EnumSet.noneOf(SlotSemantic.class);
    protected final WidgetContainer widgets;
    protected final ScreenStyle style;
    private static final Style TOOLTIP_HEADER = Style.field_240709_b_.func_240721_b_(TextFormatting.WHITE);
    private static final Style TOOLTIP_BODY = Style.field_240709_b_.func_240721_b_(TextFormatting.GRAY);

    public AEBaseScreen(T container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title);
        this.field_230707_j_ = Minecraft.func_71410_x().func_175599_af();
        this.field_230712_o_ = Minecraft.func_71410_x().field_71466_p;
        this.style = Objects.requireNonNull(style, "style");
        this.widgets = new WidgetContainer(style);
        this.verticalToolbar = new VerticalButtonBar();
        this.widgets.add("verticalToolbar", this.verticalToolbar);
        if (style.getBackground() != null) {
            this.field_146999_f = style.getBackground().getSrcWidth();
            this.field_147000_g = style.getBackground().getSrcHeight();
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.positionSlots(this.style);
        this.widgets.populateScreen(arg_0 -> ((AEBaseScreen)this).func_230480_a_(arg_0), this.getBounds(true), this);
    }

    private void positionSlots(ScreenStyle style) {
        for (Map.Entry<SlotSemantic, SlotPosition> entry : style.getSlots().entrySet()) {
            if (this.hiddenSlots.contains((Object)entry.getKey())) continue;
            List<Slot> slots = ((AEBaseContainer)this.field_147002_h).getSlots(entry.getKey());
            for (int i = 0; i < slots.size(); ++i) {
                Slot slot = slots.get(i);
                Point pos = this.getSlotPosition(entry.getValue(), i);
                slot.field_75223_e = pos.getX();
                slot.field_75221_f = pos.getY();
            }
            List guiSlots = this.guiSlotsBySemantic.get((Object)entry.getKey());
            if (guiSlots == null) continue;
            for (int i = 0; i < guiSlots.size(); ++i) {
                CustomSlotWidget guiSlot = (CustomSlotWidget)guiSlots.get(i);
                Point pos = this.getSlotPosition(entry.getValue(), i);
                guiSlot.setPos(pos);
            }
        }
    }

    private Point getSlotPosition(SlotPosition position, int semanticIndex) {
        Point pos = position.resolve(this.getBounds(false));
        SlotGridLayout grid = position.getGrid();
        if (grid != null) {
            pos = grid.getPosition(pos.getX(), pos.getY(), semanticIndex);
        }
        return pos;
    }

    private Rectangle2d getBounds(boolean absolute) {
        if (absolute) {
            return new Rectangle2d(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        }
        return new Rectangle2d(0, 0, this.field_146999_f, this.field_147000_g);
    }

    private List<Slot> getInventorySlots() {
        return ((AEBaseContainer)this.field_147002_h).field_75151_b;
    }

    protected final void addSlot(CustomSlotWidget slot, SlotSemantic semantic) {
        this.guiSlots.add(slot);
        this.guiSlotsBySemantic.put((Object)semantic, (Object)slot);
    }

    @OverridingMethodsMustInvokeSuper
    protected void updateBeforeRender() {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.updateBeforeRender();
        this.widgets.updateBeforeRender();
        super.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.field_147003_i, (double)this.field_147009_r, 0.0);
        RenderSystem.enableDepthTest();
        for (CustomSlotWidget c : this.guiSlots) {
            this.drawGuiSlot(matrixStack, c, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableDepthTest();
        for (CustomSlotWidget c : this.guiSlots) {
            Tooltip tooltip = c.getTooltip(mouseX, mouseY);
            if (tooltip == null) continue;
            this.drawTooltip(matrixStack, tooltip, mouseX, mouseY);
        }
        matrixStack.func_227865_b_();
        RenderSystem.enableDepthTest();
        this.renderTooltips(matrixStack, mouseX, mouseY);
        if (AEConfig.instance().isShowDebugGuiOverlays()) {
            List<Rectangle2d> exclusionZones = this.getExclusionZones();
            for (Rectangle2d rectangle2d : exclusionZones) {
                this.fillRect(matrixStack, rectangle2d, 0x7F00FF00);
            }
            this.func_238465_a_(matrixStack, this.field_147003_i, this.field_147003_i + this.field_146999_f - 1, this.field_147009_r, -1);
            this.func_238465_a_(matrixStack, this.field_147003_i, this.field_147003_i + this.field_146999_f - 1, this.field_147009_r + this.field_147000_g - 1, -1);
            this.func_238473_b_(matrixStack, this.field_147003_i, this.field_147009_r, this.field_147009_r + this.field_147000_g, -1);
            this.func_238473_b_(matrixStack, this.field_147003_i + this.field_146999_f - 1, this.field_147009_r, this.field_147009_r + this.field_147000_g - 1, -1);
        }
    }

    private void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            return;
        }
        for (Widget c : this.field_230710_m_) {
            Tooltip tooltip;
            if (!(c instanceof ITooltip) || (tooltip = ((ITooltip)c).getTooltip(mouseX, mouseY)) == null) continue;
            this.drawTooltip(matrixStack, tooltip, mouseX, mouseY);
        }
        Tooltip tooltip = this.widgets.getTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (tooltip != null) {
            this.drawTooltip(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    protected void drawGuiSlot(MatrixStack matrixStack, CustomSlotWidget slot, int mouseX, int mouseY, float partialTicks) {
        if (slot.isSlotEnabled()) {
            int left = slot.getTooltipAreaX();
            int top = slot.getTooltipAreaY();
            int right = left + slot.getTooltipAreaWidth();
            int bottom = top + slot.getTooltipAreaHeight();
            slot.drawContent(matrixStack, this.getMinecraft(), mouseX, mouseY, partialTicks);
            if (this.func_195359_a(left, top, slot.getTooltipAreaWidth(), slot.getTooltipAreaHeight(), mouseX, mouseY) && slot.canClick((PlayerEntity)this.getPlayer())) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_238468_a_(matrixStack, left, top, right, bottom, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
    }

    private void drawTooltip(MatrixStack matrixStack, Tooltip tooltip, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltip.getContent(), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)200, (FontRenderer)this.field_230712_o_);
    }

    public void drawTooltip(MatrixStack matrices, int x, int y, List<ITextComponent> lines) {
        if (lines.isEmpty()) {
            return;
        }
        ArrayList<IFormattableTextComponent> styledLines = new ArrayList<IFormattableTextComponent>(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            Style style = i == 0 ? TOOLTIP_HEADER : TOOLTIP_BODY;
            styledLines.add(lines.get(i).func_230532_e_().func_240700_a_(s -> style));
        }
        this.func_243308_b(matrices, styledLines, x, y);
    }

    protected final void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        this.widgets.drawForegroundLayer(matrixStack, this.func_230927_p_(), this.getBounds(false), new Point(x - ox, y - oy));
        this.drawFG(matrixStack, ox, oy, x, y);
        if (this.style != null) {
            for (Map.Entry<String, Text> entry : this.style.getText().entrySet()) {
                TextOverride override = this.textOverrides.get(entry.getKey());
                this.drawText(matrixStack, entry.getValue(), override);
            }
        }
    }

    private void drawText(MatrixStack matrixStack, Text text, @Nullable TextOverride override) {
        if (override != null && override.isHidden()) {
            return;
        }
        int color = this.style.getColor(text.getColor()).toARGB();
        ITextComponent content = text.getText();
        if (override != null && override.getContent() != null) {
            content = override.getContent();
        }
        Point pos = text.getPosition().resolve(this.getBounds(false));
        if (text.isCenterHorizontally()) {
            int textWidth = this.field_230712_o_.func_238414_a_((ITextProperties)content);
            pos = pos.move(-textWidth / 2, 0);
        }
        this.field_230712_o_.func_243248_b(matrixStack, content, (float)pos.getX(), (float)pos.getY(), color);
    }

    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    protected final void func_230450_a_(MatrixStack matrixStack, float f, int x, int y) {
        this.drawBG(matrixStack, this.field_147003_i, this.field_147009_r, x, y, f);
        this.widgets.drawBackgroundLayer(matrixStack, this.func_230927_p_(), this.getBounds(true), new Point(x - this.field_147003_i, y - this.field_147009_r));
        for (Slot slot : this.getInventorySlots()) {
            if (!(slot instanceof IOptionalSlot)) continue;
            this.drawOptionalSlotBackground(matrixStack, (IOptionalSlot)slot, false);
        }
        for (CustomSlotWidget customSlotWidget : this.guiSlots) {
            if (!(customSlotWidget instanceof IOptionalSlot)) continue;
            this.drawOptionalSlotBackground(matrixStack, (IOptionalSlot)((Object)customSlotWidget), true);
        }
    }

    private void drawOptionalSlotBackground(MatrixStack matrixStack, IOptionalSlot slot, boolean alwaysDraw) {
        if (alwaysDraw || slot.isRenderDisabled()) {
            float alpha = slot.isSlotEnabled() ? 1.0f : 0.4f;
            Point pos = slot.getBackgroundPos();
            Icon.SLOT_BACKGROUND.getBlitter().dest(this.field_147003_i + pos.getX(), this.field_147009_r + pos.getY()).color(1.0f, 1.0f, 1.0f, alpha).blit(matrixStack, this.func_230927_p_());
        }
    }

    private Point getMousePoint(double x, double y) {
        return new Point((int)Math.round(x - (double)this.field_147003_i), (int)Math.round(y - (double)this.field_147009_r));
    }

    public boolean func_231043_a_(double x, double y, double wheelDelta) {
        return wheelDelta != 0.0 && this.widgets.onMouseWheel(this.getMousePoint(x, y), wheelDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_231044_a_(double xCoord, double yCoord, int btn) {
        CustomSlotWidget slot;
        this.drag_click.clear();
        if (btn == 1) {
            this.handlingRightClick = true;
            try {
                for (Widget widget : this.field_230710_m_) {
                    if (!widget.func_231047_b_(xCoord, yCoord)) continue;
                    boolean bl = super.func_231044_a_(xCoord, yCoord, 0);
                    return bl;
                }
            }
            finally {
                this.handlingRightClick = false;
            }
        }
        if ((slot = this.getGuiSlotAt(xCoord, yCoord)) != null) {
            slot.slotClicked(this.getPlayer().field_71071_by.func_70445_o(), btn);
        }
        if (this.widgets.onMouseDown(this.getMousePoint(xCoord, yCoord), btn)) {
            return true;
        }
        return super.func_231044_a_(xCoord, yCoord, btn);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.widgets.onMouseUp(this.getMousePoint(mouseX, mouseY), button)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        Slot slot = this.getSlot((int)mouseX, (int)mouseY);
        ItemStack itemstack = this.getPlayer().field_71071_by.func_70445_o();
        Point mousePos = new Point((int)Math.round(mouseX - (double)this.field_147003_i), (int)Math.round(mouseY - (double)this.field_147009_r));
        if (this.widgets.onMouseDrag(mousePos, mouseButton)) {
            return true;
        }
        if (slot instanceof FakeSlot && !itemstack.func_190926_b()) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (Slot dr : this.drag_click) {
                    InventoryActionPacket p = new InventoryActionPacket(mouseButton == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.field_75222_d, 0L);
                    NetworkHandler.instance().sendToServer(p);
                }
            }
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    protected void func_184098_a(@Nullable Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof DisabledSlot) {
            return;
        }
        if (slot instanceof FakeSlot) {
            InventoryAction action;
            InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (this.drag_click.size() > 1) {
                return;
            }
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof PatternTermSlot) {
            if (mouseButton == 6) {
                return;
            }
            NetworkHandler.instance().sendToServer(((PatternTermSlot)slot).getRequest(AEBaseScreen.func_231173_s_()));
        } else if (slot instanceof CraftingTermSlot) {
            if (mouseButton == 6) {
                return;
            }
            InventoryAction action = AEBaseScreen.func_231173_s_() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot != null && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32)) {
            int slotNum = slot.field_75222_d;
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot != null && !this.disableShiftClick && AEBaseScreen.func_231173_s_() && mouseButton == 0) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem.func_190926_b() || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 250L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
            } else if (!this.dbl_whichItem.func_190926_b()) {
                List<Slot> slots = this.getInventorySlots();
                for (Slot inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.func_82869_a((PlayerEntity)this.getPlayer()) || !inventorySlot.func_75216_d() || !inventorySlot.isSameInventory(slot) || !Container.func_94527_a((Slot)inventorySlot, (ItemStack)this.dbl_whichItem, (boolean)true)) continue;
                    this.func_184098_a(inventorySlot, inventorySlot.field_75222_d, 0, ClickType.QUICK_MOVE);
                }
                this.dbl_whichItem = ItemStack.field_190927_a;
            }
            this.disableShiftClick = false;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    protected boolean func_195363_d(int keyCode, int scanCode) {
        return this.checkHotbarKeys(InputMappings.func_197954_a((int)keyCode, (int)scanCode));
    }

    protected ClientPlayerEntity getPlayer() {
        return (ClientPlayerEntity)Preconditions.checkNotNull((Object)this.getMinecraft().field_71439_g);
    }

    protected boolean checkHotbarKeys(InputMappings.Input input) {
        Slot theSlot = this.getSlotUnderMouse();
        if (this.getPlayer().field_71071_by.func_70445_o().func_190926_b() && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (!this.getMinecraft().field_71474_y.field_151456_ac[j].isActiveAndMatches(input)) continue;
                List<Slot> slots = this.getInventorySlots();
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInventory() || s.func_82869_a(((AEBaseContainer)this.field_147002_h).getPlayerInventory().field_70458_d)) continue;
                    return false;
                }
                if (theSlot.func_75219_a() == 64) {
                    this.func_184098_a(theSlot, theSlot.field_75222_d, j, ClickType.SWAP);
                    return true;
                }
                for (Slot s : slots) {
                    if (s.getSlotIndex() != j || s.field_75224_c != ((AEBaseContainer)this.field_147002_h).getPlayerInventory()) continue;
                    NetworkHandler.instance().sendToServer(new SwapSlotsPacket(s.field_75222_d, theSlot.field_75222_d));
                    return true;
                }
            }
        }
        return false;
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        List<Slot> slots = this.getInventorySlots();
        for (Slot slot : slots) {
            if (!this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        if (this.style.getBackground() != null) {
            this.style.getBackground().dest(offsetX, offsetY).blit(matrixStack, this.func_230927_p_());
        }
    }

    public void drawItem(int x, int y, ItemStack is) {
        this.field_230707_j_.field_77023_b = 100.0f;
        RenderHelper.func_227780_a_();
        this.field_230707_j_.func_180450_b(is, x, y);
        RenderHelper.func_74518_a();
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    protected ITextComponent getGuiDisplayName(ITextComponent in) {
        return this.field_230704_d_.getString().isEmpty() ? in : this.field_230704_d_;
    }

    protected void func_238746_a_(MatrixStack matrices, Slot s) {
        if (s instanceof AppEngSlot) {
            try {
                this.renderAppEngSlot(matrices, (AppEngSlot)s);
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
            }
        } else {
            super.func_238746_a_(matrices, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAppEngSlot(MatrixStack matrices, AppEngSlot s) {
        ItemStack is = s.func_75211_c();
        if ((s.renderIconWithItem() || is.func_190926_b()) && s.isSlotEnabled() && s.getIcon() != null) {
            s.getIcon().getBlitter().dest(s.field_75223_e, s.field_75221_f).opacity(s.getOpacityOfIcon()).blit(matrices, this.func_230927_p_());
        }
        if (!s.isValid()) {
            AEBaseScreen.func_238467_a_((MatrixStack)matrices, (int)s.field_75223_e, (int)s.field_75221_f, (int)(16 + s.field_75223_e), (int)(16 + s.field_75221_f), (int)0x66FF6666);
        }
        s.setRendering(true);
        try {
            super.func_238746_a_(matrices, (Slot)s);
        }
        finally {
            s.setRendering(false);
        }
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/" + file);
        this.getMinecraft().func_110434_K().func_110577_a(loc);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.widgets.tick();
        for (IGuiEventListener child : this.field_230705_e_) {
            if (!(child instanceof ITickingWidget)) continue;
            ((ITickingWidget)child).tick();
        }
    }

    public boolean isHandlingRightClick() {
        return this.handlingRightClick;
    }

    protected final <B extends Button> B addToLeftToolbar(B button) {
        this.verticalToolbar.add(button);
        return button;
    }

    public List<Rectangle2d> getExclusionZones() {
        ArrayList<Rectangle2d> result = new ArrayList<Rectangle2d>(2);
        this.widgets.addExclusionZones(result, this.getBounds(true));
        return result;
    }

    protected void fillRect(MatrixStack matrices, Rectangle2d rect, int color) {
        AEBaseScreen.func_238467_a_((MatrixStack)matrices, (int)rect.func_199318_a(), (int)rect.func_199319_b(), (int)(rect.func_199318_a() + rect.func_199316_c()), (int)(rect.func_199319_b() + rect.func_199317_d()), (int)color);
    }

    private TextOverride getOrCreateTextOverride(String id) {
        return this.textOverrides.computeIfAbsent(id, x -> new TextOverride());
    }

    protected final void setTextHidden(String id, boolean hidden) {
        this.getOrCreateTextOverride(id).setHidden(hidden);
    }

    protected final void setSlotsHidden(SlotSemantic semantic, boolean hidden) {
        if (hidden) {
            if (this.hiddenSlots.add(semantic)) {
                for (Slot slot : ((AEBaseContainer)this.field_147002_h).getSlots(semantic)) {
                    slot.field_75223_e = HIDDEN_SLOT_POS.getX();
                    slot.field_75221_f = HIDDEN_SLOT_POS.getY();
                }
            }
        } else if (this.hiddenSlots.remove((Object)semantic) && this.style != null) {
            this.positionSlots(this.style);
        }
    }

    @Nullable
    private CustomSlotWidget getGuiSlotAt(double x, double y) {
        for (CustomSlotWidget slot : this.guiSlots) {
            if (!this.func_195359_a(slot.getTooltipAreaX(), slot.getTooltipAreaY(), slot.getTooltipAreaWidth(), slot.getTooltipAreaHeight(), x, y) || !slot.canClick((PlayerEntity)this.getPlayer())) continue;
            return slot;
        }
        return null;
    }

    public List<CustomSlotWidget> getGuiSlots() {
        return Collections.unmodifiableList(this.guiSlots);
    }

    protected final void setTextContent(String id, ITextComponent content) {
        this.getOrCreateTextOverride(id).setContent(content);
    }

    public ScreenStyle getStyle() {
        return this.style;
    }

    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        IIngredientSupplier ingredientSupplier = null;
        CustomSlotWidget guiSlot = this.getGuiSlotAt(mouseX, mouseY);
        if (guiSlot instanceof IIngredientSupplier) {
            ingredientSupplier = (IIngredientSupplier)((Object)guiSlot);
        }
        if (ingredientSupplier == null) {
            for (IGuiEventListener child : this.field_230705_e_) {
                if (!(child instanceof IIngredientSupplier) || !child.func_231047_b_(mouseX, mouseY)) continue;
                ingredientSupplier = (IIngredientSupplier)child;
                break;
            }
        }
        FluidStack ingredient = null;
        if (ingredientSupplier != null && (ingredient = ingredientSupplier.getFluidIngredient()) == null) {
            ingredient = ingredientSupplier.getItemIngredient();
        }
        return ingredient;
    }
}

