/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.definitions.IDefinitions;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.IOPortContainer;
import appeng.core.Api;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class IOPortScreen
extends UpgradeableScreen<IOPortContainer> {
    private final SettingToggleButton<FullnessMode> fullMode = new ServerSettingToggleButton<FullnessMode>(Settings.FULLNESS_MODE, FullnessMode.EMPTY);
    private final SettingToggleButton<OperationMode> operationMode;
    private final SettingToggleButton<RedstoneMode> redstoneMode;

    public IOPortScreen(IOPortContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.addToLeftToolbar(this.fullMode);
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.addToLeftToolbar(this.redstoneMode);
        this.operationMode = new ServerSettingToggleButton<OperationMode>(Settings.OPERATION_MODE, OperationMode.EMPTY);
        this.widgets.add("operationMode", (Widget)this.operationMode);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set(((IOPortContainer)this.field_147002_h).getRedStoneMode());
        this.operationMode.set(((IOPortContainer)this.field_147002_h).getOperationMode());
        this.fullMode.set(((IOPortContainer)this.field_147002_h).getFullMode());
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        IDefinitions definitions = Api.instance().definitions();
        definitions.items().cell1k().maybeStack(1).ifPresent(cell1kStack -> this.drawItem(offsetX + 66 - 8, offsetY + 17, (ItemStack)cell1kStack));
        definitions.blocks().drive().maybeStack(1).ifPresent(driveStack -> this.drawItem(offsetX + 94 + 8, offsetY + 17, (ItemStack)driveStack));
    }
}

