/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.LevelEmitterContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class LevelEmitterScreen
extends UpgradeableScreen<LevelEmitterContainer> {
    private final SettingToggleButton<LevelType> levelMode = new ServerSettingToggleButton<LevelType>(Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
    private final SettingToggleButton<YesNo> craftingMode;
    private final SettingToggleButton<RedstoneMode> redstoneMode = new ServerSettingToggleButton<RedstoneMode>(Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
    private final SettingToggleButton<FuzzyMode> fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
    private final NumberEntryWidget level;

    public LevelEmitterScreen(LevelEmitterContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.craftingMode = new ServerSettingToggleButton<YesNo>(Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        this.addToLeftToolbar(this.levelMode);
        this.addToLeftToolbar(this.redstoneMode);
        this.addToLeftToolbar(this.craftingMode);
        this.addToLeftToolbar(this.fuzzyMode);
        this.level = new NumberEntryWidget(NumberEntryType.LEVEL_ITEM_COUNT);
        this.level.setTextFieldBounds(25, 44, 75);
        this.level.setValue(container.getReportingValue());
        this.level.setOnChange(this::saveReportingValue);
        this.level.setOnConfirm(() -> ((LevelEmitterScreen)this).func_231175_as__());
        this.widgets.add("level", this.level);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.fuzzyMode.set(((LevelEmitterContainer)this.field_147002_h).getFuzzyMode());
        this.fuzzyMode.setVisibility(((LevelEmitterContainer)this.field_147002_h).hasUpgrade(Upgrades.FUZZY));
        boolean notCraftingMode = !((LevelEmitterContainer)this.field_147002_h).hasUpgrade(Upgrades.CRAFTING);
        this.level.setActive(notCraftingMode);
        this.redstoneMode.field_230693_o_ = notCraftingMode;
        this.redstoneMode.set(((LevelEmitterContainer)this.field_147002_h).getRedStoneMode());
        LevelType currentLevelMode = ((LevelEmitterContainer)this.field_147002_h).getLevelMode();
        this.levelMode.field_230693_o_ = notCraftingMode;
        this.levelMode.set(currentLevelMode);
        this.craftingMode.set(((LevelEmitterContainer)this.field_147002_h).getCraftingMode());
        this.craftingMode.setVisibility(!notCraftingMode);
        this.setTextHidden("energy_unit", !notCraftingMode || currentLevelMode != LevelType.ENERGY_LEVEL);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.level.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void saveReportingValue() {
        this.level.getLongValue().ifPresent(((LevelEmitterContainer)this.field_147002_h)::setReportingValue);
    }
}

