/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.client.render.DelegateBakedModel;
import appeng.items.misc.EncodedPatternItem;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.PerspectiveMapWrapper;

public class EncodedPatternBakedModel
extends DelegateBakedModel {
    private final CustomOverrideList overrides = new CustomOverrideList();

    EncodedPatternBakedModel(IBakedModel baseModel) {
        super(baseModel);
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    @Override
    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this.getBaseModel().handlePerspective(cameraTransformType, mat);
    }

    private class CustomOverrideList
    extends ItemOverrideList {
        private CustomOverrideList() {
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            EncodedPatternItem iep;
            ItemStack output;
            boolean shiftHeld = Screen.func_231173_s_();
            if (shiftHeld && !(output = (iep = (EncodedPatternItem)stack.func_77973_b()).getOutput(stack)).func_190926_b()) {
                IBakedModel realModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(output);
                realModel = realModel.func_188617_f().func_239290_a_(realModel, output, world, entity);
                return new ShiftHoldingModelWrapper(EncodedPatternBakedModel.this.getBaseModel(), realModel);
            }
            return EncodedPatternBakedModel.this.getBaseModel().func_188617_f().func_239290_a_(originalModel, stack, world, entity);
        }
    }

    private static class ShiftHoldingModelWrapper
    extends DelegateBakedModel {
        private final IBakedModel outputModel;

        private ShiftHoldingModelWrapper(IBakedModel patternModel, IBakedModel outputModel) {
            super(patternModel);
            this.outputModel = outputModel;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        @Override
        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)this.outputModel.func_177552_f());
                return PerspectiveMapWrapper.handlePerspective((IBakedModel)this.outputModel, (ImmutableMap)transforms, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)mat);
            }
            return this.getBaseModel().handlePerspective(cameraTransformType, mat);
        }

        @Override
        public boolean func_230044_c_() {
            return this.outputModel.func_230044_c_();
        }
    }
}

