/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.network.NetworkHooks;

public final class ContainerTypeBuilder<C extends AEBaseContainer, I> {
    private final Class<I> hostInterface;
    private final ContainerFactory<C, I> factory;
    private Function<I, ITextComponent> containerTitleStrategy = this::getDefaultContainerTitle;
    @Nullable
    private SecurityPermissions requiredPermission;
    @Nullable
    private InitialDataSerializer<I> initialDataSerializer;
    @Nullable
    private InitialDataDeserializer<C, I> initialDataDeserializer;
    private ContainerType<C> containerType;

    private ContainerTypeBuilder(Class<I> hostInterface, TypedContainerFactory<C, I> typedFactory) {
        this.hostInterface = hostInterface;
        this.factory = (windowId, playerInv, accessObj) -> (AEBaseContainer)((Object)((Object)typedFactory.create(this.containerType, windowId, playerInv, accessObj)));
    }

    private ContainerTypeBuilder(Class<I> hostInterface, ContainerFactory<C, I> factory) {
        this.hostInterface = hostInterface;
        this.factory = factory;
    }

    public static <C extends AEBaseContainer, I> ContainerTypeBuilder<C, I> create(ContainerFactory<C, I> factory, Class<I> hostInterface) {
        return new ContainerTypeBuilder<C, I>(hostInterface, factory);
    }

    public static <C extends AEBaseContainer, I> ContainerTypeBuilder<C, I> create(TypedContainerFactory<C, I> factory, Class<I> hostInterface) {
        return new ContainerTypeBuilder<C, I>(hostInterface, factory);
    }

    public ContainerTypeBuilder<C, I> requirePermission(SecurityPermissions permission) {
        this.requiredPermission = permission;
        return this;
    }

    public ContainerTypeBuilder<C, I> withContainerTitle(Function<I, ITextComponent> containerTitleStrategy) {
        this.containerTitleStrategy = containerTitleStrategy;
        return this;
    }

    public ContainerTypeBuilder<C, I> withInitialData(InitialDataSerializer<I> initialDataSerializer, InitialDataDeserializer<C, I> initialDataDeserializer) {
        this.initialDataSerializer = initialDataSerializer;
        this.initialDataDeserializer = initialDataDeserializer;
        return this;
    }

    private C fromNetwork(int windowId, PlayerInventory inv, PacketBuffer packetBuf) {
        I host = this.getHostFromLocator(inv.field_70458_d, ContainerLocator.read(packetBuf));
        if (host != null) {
            AEBaseContainer container = (AEBaseContainer)((Object)this.factory.create(windowId, inv, host));
            if (this.initialDataDeserializer != null) {
                this.initialDataDeserializer.deserializeInitialData(host, container, packetBuf);
            }
            return (C)((Object)container);
        }
        return null;
    }

    private boolean open(PlayerEntity player, ContainerLocator locator) {
        if (!(player instanceof ServerPlayerEntity)) {
            return false;
        }
        I accessInterface = this.getHostFromLocator(player, locator);
        if (accessInterface == null) {
            return false;
        }
        if (!this.checkPermission(player, accessInterface)) {
            return false;
        }
        ITextComponent title = this.containerTitleStrategy.apply(accessInterface);
        SimpleNamedContainerProvider container = new SimpleNamedContainerProvider((wnd, p, pl) -> {
            AEBaseContainer c = (AEBaseContainer)((Object)((Object)this.factory.create(wnd, p, accessInterface)));
            c.setLocator(locator);
            return c;
        }, title);
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)container, buffer -> {
            locator.write((PacketBuffer)buffer);
            if (this.initialDataSerializer != null) {
                this.initialDataSerializer.serializeInitialData(accessInterface, (PacketBuffer)buffer);
            }
        });
        return true;
    }

    private I getHostFromLocator(PlayerEntity player, ContainerLocator locator) {
        if (locator.hasItemIndex()) {
            return this.getHostFromPlayerInventory(player, locator);
        }
        if (!locator.hasBlockPos()) {
            return null;
        }
        TileEntity tileEntity = player.field_70170_p.func_175625_s(locator.getBlockPos());
        if (this.hostInterface.isInstance(tileEntity)) {
            return this.hostInterface.cast(tileEntity);
        }
        if (!locator.hasSide()) {
            return null;
        }
        if (tileEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)tileEntity;
            IPart part = partHost.getPart(locator.getSide());
            if (part == null) {
                return null;
            }
            if (this.hostInterface.isInstance(part)) {
                return this.hostInterface.cast(part);
            }
            AELog.debug("Trying to open a container @ %s for a %s, but the container requires %s", locator, part.getClass(), this.hostInterface);
            return null;
        }
        return null;
    }

    private I getHostFromPlayerInventory(PlayerEntity player, ContainerLocator locator) {
        IWirelessTermHandler wh;
        ItemStack it = player.field_71071_by.func_70301_a(locator.getItemIndex());
        if (it.func_190926_b()) {
            AELog.debug("Cannot open container for player %s since they no longer hold the item in slot %d", player, locator.hasItemIndex());
            return null;
        }
        if (it.func_77973_b() instanceof IGuiItem) {
            IGuiItem guiItem = (IGuiItem)it.func_77973_b();
            BlockPos blockPos = locator.hasBlockPos() ? locator.getBlockPos() : null;
            IGuiItemObject guiObject = guiItem.getGuiObject(it, locator.getItemIndex(), player.field_70170_p, blockPos);
            if (this.hostInterface.isInstance(guiObject)) {
                return this.hostInterface.cast(guiObject);
            }
        }
        if (this.hostInterface.isAssignableFrom(WirelessTerminalGuiObject.class) && (wh = Api.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return this.hostInterface.cast(new WirelessTerminalGuiObject(wh, it, player, locator.getItemIndex()));
        }
        return null;
    }

    public ContainerType<C> build(String id) {
        Preconditions.checkState((this.containerType == null ? 1 : 0) != 0, (Object)"build was already called");
        this.containerType = IForgeContainerType.create(this::fromNetwork);
        this.containerType.setRegistryName("appliedenergistics2", id);
        ContainerOpener.addOpener(this.containerType, this::open);
        return this.containerType;
    }

    private boolean checkPermission(PlayerEntity player, Object accessInterface) {
        if (this.requiredPermission != null) {
            return Platform.checkPermissions(player, accessInterface, this.requiredPermission, true);
        }
        return true;
    }

    private ITextComponent getDefaultContainerTitle(I accessInterface) {
        ICustomNameObject customNameObject;
        if (accessInterface instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)accessInterface).hasCustomInventoryName()) {
            return customNameObject.getCustomInventoryName();
        }
        return StringTextComponent.field_240750_d_;
    }

    @FunctionalInterface
    public static interface InitialDataDeserializer<C, I> {
        public void deserializeInitialData(I var1, C var2, PacketBuffer var3);
    }

    @FunctionalInterface
    public static interface InitialDataSerializer<I> {
        public void serializeInitialData(I var1, PacketBuffer var2);
    }

    @FunctionalInterface
    public static interface TypedContainerFactory<C extends Container, I> {
        public C create(ContainerType<C> var1, int var2, PlayerInventory var3, I var4);
    }

    @FunctionalInterface
    public static interface ContainerFactory<C, I> {
        public C create(int var1, PlayerInventory var2, I var3);
    }
}

