/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.me.GridAccessException;
import appeng.me.cache.StatisticsCache;
import appeng.tile.spatial.SpatialAnchorTileEntity;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SpatialAnchorContainer
extends AEBaseContainer {
    public static final ContainerType<SpatialAnchorContainer> TYPE = ContainerTypeBuilder.create(SpatialAnchorContainer::new, SpatialAnchorTileEntity.class).requirePermission(SecurityPermissions.BUILD).build("spatialanchor");
    private static final int UPDATE_DELAY = 20;
    private IGrid network;
    private int delay = 20;
    @GuiSync(value=0)
    public long powerConsumption;
    @GuiSync(value=1)
    public int loadedChunks;
    @GuiSync(value=2)
    public YesNo overlayMode = YesNo.NO;
    @GuiSync(value=10)
    public int allLoadedWorlds;
    @GuiSync(value=11)
    public int allLoadedChunks;
    @GuiSync(value=20)
    public int allWorlds;
    @GuiSync(value=21)
    public int allChunks;

    public SpatialAnchorContainer(int id, PlayerInventory ip, SpatialAnchorTileEntity spatialAnchor) {
        super(TYPE, id, ip, spatialAnchor);
        if (this.isServer()) {
            this.network = spatialAnchor.getGridNode(AEPartLocation.INTERNAL).getGrid();
        }
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            SpatialAnchorTileEntity anchor = (SpatialAnchorTileEntity)this.getTileEntity();
            this.setOverlayMode((YesNo)anchor.getConfigManager().getSetting(Settings.OVERLAY_MODE));
            ++this.delay;
            if (this.delay > 20 && this.network != null) {
                StatisticsCache statistics = (StatisticsCache)this.network.getCache(StatisticsCache.class);
                this.powerConsumption = (long)anchor.getProxy().getIdlePowerUsage();
                this.loadedChunks = ((SpatialAnchorTileEntity)this.getTileEntity()).countLoadedChunks();
                try {
                    HashMap<World, Integer> stats = new HashMap<World, Integer>();
                    IMachineSet anchors = anchor.getProxy().getGrid().getMachines(SpatialAnchorTileEntity.class);
                    for (IGridNode machine : anchors) {
                        SpatialAnchorTileEntity a = (SpatialAnchorTileEntity)machine.getMachine();
                        World world = machine.getGridBlock().getLocation().getWorld();
                        stats.merge(world, a.countLoadedChunks(), Math::max);
                    }
                    this.allLoadedChunks = stats.values().stream().reduce(Integer::sum).orElse(0);
                    this.allLoadedWorlds = stats.keySet().size();
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                this.allWorlds = statistics.getChunks().size();
                this.allChunks = 0;
                for (Map.Entry<IWorld, Multiset<ChunkPos>> entry : statistics.getChunks().entrySet()) {
                    this.allChunks += entry.getValue().elementSet().size();
                }
                this.delay = 0;
            }
        }
        super.func_75142_b();
    }

    public YesNo getOverlayMode() {
        return this.overlayMode;
    }

    public void setOverlayMode(YesNo mode) {
        this.overlayMode = mode;
    }
}

