/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.common;

import appeng.api.storage.data.IAEStack;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class IncrementalUpdateHelper<T extends IAEStack<T>>
implements Iterable<T> {
    private final BiMap<T, Long> mapping;
    private final Set<T> changes = new HashSet<T>();
    private long serial;
    private boolean fullUpdate = true;

    public IncrementalUpdateHelper() {
        this.mapping = HashBiMap.create();
    }

    @Nullable
    public Long getSerial(T stack) {
        return (Long)this.mapping.get(stack);
    }

    public long getOrAssignSerial(T stack) {
        return (Long)this.mapping.computeIfAbsent(stack, key -> ++this.serial);
    }

    public T getBySerial(long serial) {
        return (T)((IAEStack)this.mapping.inverse().get((Object)serial));
    }

    public void clear() {
        this.mapping.clear();
        this.changes.clear();
        this.fullUpdate = true;
    }

    public void addChange(T entry) {
        if (!this.changes.add(entry)) {
            this.changes.remove(entry);
            this.changes.add(entry);
        }
    }

    public void commitChanges() {
        for (IAEStack stack : this.changes) {
            if (stack.isMeaningful()) continue;
            this.mapping.remove((Object)stack);
        }
        this.changes.clear();
        this.fullUpdate = false;
    }

    public boolean hasChanges() {
        return this.fullUpdate || !this.changes.isEmpty();
    }

    public boolean isFullUpdate() {
        return this.fullUpdate;
    }

    @Override
    public Iterator<T> iterator() {
        return this.changes.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.changes.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.changes.spliterator();
    }
}

