/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.common.IncrementalUpdateHelper;
import appeng.container.me.crafting.CraftingStatus;
import appeng.core.Api;
import appeng.core.sync.packets.CraftingStatusPacket;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.CraftingTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.text.StringTextComponent;

public class CraftingCPUContainer
extends AEBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack> {
    public static final ContainerType<CraftingCPUContainer> TYPE = ContainerTypeBuilder.create(CraftingCPUContainer::new, CraftingTileEntity.class).requirePermission(SecurityPermissions.CRAFT).withContainerTitle(craftingTileEntity -> {
        CraftingCPUCluster cluster = craftingTileEntity.getCluster();
        if (cluster != null && cluster.getName() != null) {
            return cluster.getName();
        }
        return StringTextComponent.field_240750_d_;
    }).build("craftingcpu");
    private final IncrementalUpdateHelper<IAEItemStack> incrementalUpdateHelper = new IncrementalUpdateHelper();
    private final IGrid grid;
    private CraftingCPUCluster cpu = null;

    public CraftingCPUContainer(ContainerType<?> containerType, int id, PlayerInventory ip, Object te) {
        super(containerType, id, ip, te);
        IActionHost host = (IActionHost)(te instanceof IActionHost ? te : null);
        this.grid = host != null && host.getActionableNode() != null ? host.getActionableNode().getGrid() : null;
        if (te instanceof CraftingTileEntity) {
            this.setCPU(((CraftingTileEntity)te).getCluster());
        }
        if (this.getGrid() == null && this.isServer()) {
            this.setValidContainer(false);
        }
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.cpu) {
            return;
        }
        if (this.cpu != null) {
            this.cpu.removeListener(this);
        }
        this.incrementalUpdateHelper.clear();
        if (c instanceof CraftingCPUCluster) {
            this.cpu = (CraftingCPUCluster)c;
            IItemList<IAEItemStack> allItems = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
            this.cpu.getListOfItem(allItems, CraftingItemList.ALL);
            for (IAEItemStack stack : allItems) {
                this.incrementalUpdateHelper.addChange(stack);
            }
            this.cpu.addListener(this, (Object)null);
        } else {
            this.cpu = null;
            this.sendPacketToClient(new CraftingStatusPacket(CraftingStatus.EMPTY));
        }
    }

    public void cancelCrafting() {
        if (this.cpu != null) {
            this.cpu.cancel();
        }
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.cpu != null) {
            this.cpu.removeListener(this);
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.cpu != null) {
            this.cpu.removeListener(this);
        }
    }

    @Override
    public void func_75142_b() {
        if (this.isServer() && this.cpu != null && this.incrementalUpdateHelper.hasChanges()) {
            CraftingStatus status = CraftingStatus.create(this.incrementalUpdateHelper, this.cpu);
            this.incrementalUpdateHelper.commitChanges();
            this.sendPacketToClient(new CraftingStatusPacket(status));
        }
        super.func_75142_b();
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        for (IAEItemStack is : change) {
            this.incrementalUpdateHelper.addChange(is);
        }
    }

    @Override
    public void onListUpdate() {
    }

    IGrid getGrid() {
        return this.grid;
    }
}

