/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.items;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.storage.ITerminalHost;
import appeng.container.ContainerNull;
import appeng.container.SlotSemantic;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.items.ItemTerminalContainer;
import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.inv.WrapperInvItemHandler;
import com.google.common.base.Preconditions;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class CraftingTermContainer
extends ItemTerminalContainer
implements IContainerCraftingPacket {
    public static final ContainerType<CraftingTermContainer> TYPE = ContainerTypeBuilder.create(CraftingTermContainer::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftingterm");
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots = new CraftingMatrixSlot[9];
    private final CraftingTermSlot outputSlot;
    private IRecipe<CraftingInventory> currentRecipe;

    public CraftingTermContainer(int id, PlayerInventory ip, ITerminalHost host) {
        super(TYPE, id, ip, host, false);
        this.craftingInventoryHost = (ISegmentedInventory)((Object)host);
        IItemHandler craftingGridInv = this.craftingInventoryHost.getInventoryByName("crafting");
        for (int i = 0; i < 9; ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot(this, craftingGridInv, i);
            this.addSlot(this.craftingSlots[i], SlotSemantic.CRAFTING_GRID);
        }
        this.outputSlot = new CraftingTermSlot(this.getPlayerInventory().field_70458_d, this.getActionSource(), this.powerSource, host, craftingGridInv, craftingGridInv, this);
        this.addSlot(this.outputSlot, SlotSemantic.CRAFTING_RESULT);
        this.createPlayerInventorySlots(ip);
        this.func_75130_a(new WrapperInvItemHandler(craftingGridInv));
    }

    public void func_75130_a(IInventory inventory) {
        ContainerNull cn = new ContainerNull();
        CraftingInventory ic = new CraftingInventory((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.func_70299_a(x, this.craftingSlots[x].func_75211_c());
        }
        World world = this.getPlayerInventory().field_70458_d.field_70170_p;
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)ic, world)) {
            this.currentRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, world).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            this.outputSlot.func_75215_d(this.currentRecipe.func_77572_b((IInventory)ic));
        }
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getPlayerInventory());
        }
        return this.craftingInventoryHost.getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return true;
    }

    public IRecipe<CraftingInventory> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClient());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.field_75222_d, 0L);
        NetworkHandler.instance().sendToServer(p);
    }

    @Override
    public boolean hasItemType(ItemStack itemStack, int amount) {
        for (Slot slot : this.getSlots(SlotSemantic.CRAFTING_GRID)) {
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot.func_190926_b() || !Platform.itemComparisons().isSameItem(itemStack, stackInSlot)) continue;
            if (itemStack.func_190916_E() >= amount) {
                return true;
            }
            amount -= itemStack.func_190916_E();
        }
        return super.hasItemType(itemStack, amount);
    }
}

