/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LightningPacket
extends BasePacket {
    private final double x;
    private final double y;
    private final double z;

    public LightningPacket(PacketBuffer stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
    }

    public LightningPacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        this.configureWrite(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        try {
            if (AEConfig.instance().isEnableEffects()) {
                player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.LIGHTNING, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

