/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.me.common.IMEInteractionHandler;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.InventoryAction;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class MEInteractionPacket
extends BasePacket {
    private final int windowId;
    private final long serial;
    private final InventoryAction action;

    public MEInteractionPacket(PacketBuffer buffer) {
        this.windowId = buffer.readInt();
        this.serial = buffer.func_179260_f();
        this.action = (InventoryAction)buffer.func_179257_a(InventoryAction.class);
    }

    public MEInteractionPacket(int windowId, long serial, InventoryAction action) {
        this.windowId = windowId;
        this.serial = serial;
        this.action = action;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(windowId);
        data.func_179254_b(serial);
        data.func_179249_a((Enum)action);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        if (player.field_71070_bA instanceof IMEInteractionHandler) {
            if (player.field_71070_bA.field_75152_c != this.windowId) {
                return;
            }
            IMEInteractionHandler handler = (IMEInteractionHandler)player.field_71070_bA;
            handler.handleInteraction(this.serial, this.action);
        }
    }
}

