/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.worlddata.CompassData;
import appeng.core.worlddata.IWorldCompassData;
import appeng.core.worlddata.IWorldData;
import appeng.core.worlddata.IWorldGridStorageData;
import appeng.core.worlddata.IWorldPlayerData;
import appeng.core.worlddata.PlayerData;
import appeng.core.worlddata.StorageData;
import appeng.services.CompassService;
import appeng.services.compass.CompassThreadFactory;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;

public final class WorldData
implements IWorldData {
    @Nullable
    private static IWorldData instance;
    @Nullable
    private static MinecraftServer server;
    private final IWorldPlayerData playerData;
    private final IWorldGridStorageData storageData;
    private final IWorldCompassData compassData;

    private WorldData(@Nonnull ServerWorld overworld) {
        Preconditions.checkNotNull((Object)overworld);
        if (overworld.func_234923_W_() != ServerWorld.field_234918_g_) {
            throw new IllegalStateException("The server doesn't have an overworld we could store our data on!");
        }
        PlayerData playerData = (PlayerData)overworld.func_217481_x().func_215752_a(PlayerData::new, "appliedenergistics2_players");
        StorageData storageData = (StorageData)overworld.func_217481_x().func_215752_a(StorageData::new, "appliedenergistics2_storage");
        CompassThreadFactory compassThreadFactory = new CompassThreadFactory();
        CompassService compassService = new CompassService(server, compassThreadFactory);
        CompassData compassData = new CompassData(compassService);
        this.playerData = playerData;
        this.storageData = storageData;
        this.compassData = compassData;
    }

    @Deprecated
    @Nonnull
    public static synchronized IWorldData instance() {
        if (instance == null) {
            if (server == null) {
                throw new IllegalStateException("No server set.");
            }
            ServerWorld overworld = server.func_71218_a(ServerWorld.field_234918_g_);
            instance = new WorldData(overworld);
        }
        return instance;
    }

    public static void onServerStarting(MinecraftServer server) {
        WorldData.server = server;
    }

    @Override
    public void onServerStopping() {
    }

    @Override
    public void onServerStoppped() {
        Preconditions.checkNotNull((Object)server);
        this.compassData.service().kill();
        instance = null;
        server = null;
    }

    @Override
    @Nonnull
    public IWorldGridStorageData storageData() {
        return this.storageData;
    }

    @Override
    @Nonnull
    public IWorldPlayerData playerData() {
        return this.playerData;
    }

    @Override
    @Nonnull
    public IWorldCompassData compassData() {
        return this.compassData;
    }
}

