/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.tags;

import appeng.api.util.AEColor;
import appeng.core.AppEng;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.BlockTagsProvider;
import java.nio.file.Path;
import net.minecraft.data.TagsProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public class ItemTagsProvider
extends net.minecraft.data.ItemTagsProvider
implements IAE2DataProvider {
    public ItemTagsProvider(GatherDataEvent dataEvent, BlockTagsProvider blockTagsProvider) {
        super(dataEvent.getGenerator(), (net.minecraft.data.BlockTagsProvider)blockTagsProvider, "appliedenergistics2", dataEvent.getExistingFileHelper());
    }

    protected void func_200432_c() {
        this.registerForgeTags();
        this.addAe2("blacklisted/annihilation_plane", new Object[0]);
        this.addAe2("dusts/certus_quartz", MATERIALS.certusQuartzDust());
        this.addAe2("dusts/ender", MATERIALS.enderDust());
        this.addAe2("dusts/fluix", MATERIALS.fluixDust());
        this.addAe2("dusts/quartz", "#appliedenergistics2:dusts/certus_quartz", "#forge:dusts/quartz");
        this.addAe2("crystals/certus", "#appliedenergistics2:crystals/certus_quartz", MATERIALS.certusQuartzCrystalCharged(), MATERIALS.purifiedCertusQuartzCrystal());
        this.addAe2("crystals/certus_quartz", MATERIALS.certusQuartzCrystal());
        this.addAe2("crystals/fluix", MATERIALS.fluixCrystal(), MATERIALS.purifiedFluixCrystal());
        this.addAe2("crystals/nether", Tags.Items.GEMS_QUARTZ, MATERIALS.purifiedNetherQuartzCrystal());
        this.addAe2("crystals/quartz", Tags.Items.GEMS_QUARTZ, "#appliedenergistics2:crystals/certus_quartz", MATERIALS.certusQuartzCrystalCharged());
        this.addAe2("workbench", Items.field_221734_cc);
        this.addAe2("wool", ItemTags.field_199904_a);
        for (AEColor color : AEColor.values()) {
            this.addAe2("smart_dense_cable", PARTS.cableDenseSmart().item(color));
            this.addAe2("smart_cable", PARTS.cableSmart().item(color));
            this.addAe2("glass_cable", PARTS.cableGlass().item(color));
            this.addAe2("covered_cable", PARTS.cableCovered().item(color));
            this.addAe2("covered_dense_cable", PARTS.cableDenseCovered().item(color));
        }
        this.addAe2("silicon", MATERIALS.silicon());
        this.addAe2("quartz_wrench", ITEMS.certusQuartzWrench(), ITEMS.netherQuartzWrench());
        this.addAe2("knife", ITEMS.certusQuartzKnife(), ITEMS.netherQuartzKnife());
        this.addAe2("nether_quartz_dust", MATERIALS.netherQuartzDust());
        this.addAe2("metal_ingots", Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_IRON);
        this.addAe2("interface", PARTS.iface(), BLOCKS.iface());
        this.addAe2("fluid_interface", PARTS.fluidIface(), BLOCKS.fluidIface());
        this.addAe2("illuminated_panel", PARTS.monitor(), PARTS.semiDarkMonitor(), PARTS.darkMonitor());
        this.addAe2("glass", Items.field_221650_am, Tags.Items.GLASS);
        this.addAe2("gears/wooden", MATERIALS.woodenGear());
    }

    private void registerForgeTags() {
        this.mirrorForgeBlockTag("ores");
        this.mirrorForgeBlockTag("ores/certus_quartz");
        this.mirrorForgeBlockTag("storage_blocks");
        this.mirrorForgeBlockTag("storage_blocks/certus_quartz");
        this.addForge("dusts/gold", MATERIALS.goldDust());
        this.addForge("dusts/iron", MATERIALS.ironDust());
        this.addForge("dusts/quartz", MATERIALS.netherQuartzDust());
        this.addForge("dusts/fluix", MATERIALS.fluixDust());
        this.addForge("dusts/certus_quartz", MATERIALS.certusQuartzDust());
        this.addForge("silicon", MATERIALS.silicon());
        this.addForge("gems/fluix", MATERIALS.fluixCrystal());
        this.addForge("gems/certus_quartz", MATERIALS.certusQuartzCrystal(), MATERIALS.certusQuartzCrystalCharged());
    }

    private void addForge(String tagName, Object ... itemSources) {
        this.add(new ResourceLocation("forge", tagName), itemSources);
    }

    private void addAe2(String tagName, Object ... itemSources) {
        this.add(AppEng.makeId(tagName), itemSources);
    }

    private void add(ResourceLocation tagName, Object ... itemSources) {
        TagsProvider.Builder builder = this.func_240522_a_((ITag.INamedTag)ItemTags.createOptional((ResourceLocation)tagName));
        for (Object itemSource : itemSources) {
            if (itemSource instanceof IItemProvider) {
                builder.func_240534_a_((Object[])new Item[]{((IItemProvider)itemSource).func_199767_j()});
                continue;
            }
            if (itemSource instanceof ITag.INamedTag) {
                builder.func_240531_a_((ITag.INamedTag)itemSource);
                continue;
            }
            if (itemSource instanceof String) {
                String itemSourceString = (String)itemSource;
                if (itemSourceString.startsWith("#")) {
                    builder.add((ITag.ITagEntry)new ITag.TagEntry(new ResourceLocation(itemSourceString.substring(1))));
                    continue;
                }
                builder.add((ITag.ITagEntry)new ITag.ItemEntry(new ResourceLocation(itemSourceString)));
                continue;
            }
            throw new IllegalArgumentException("Unknown item source: " + itemSource);
        }
    }

    private void mirrorForgeBlockTag(String tagName) {
        this.mirrorBlockTag(new ResourceLocation("forge:" + tagName));
    }

    private void mirrorAe2BlockTag(String tagName) {
        this.mirrorBlockTag(AppEng.makeId(tagName));
    }

    private void mirrorBlockTag(ResourceLocation tagName) {
        this.func_240521_a_((ITag.INamedTag)BlockTags.createOptional((ResourceLocation)tagName), (ITag.INamedTag)ItemTags.createOptional((ResourceLocation)tagName));
    }

    protected Path func_200431_a(ResourceLocation id) {
        return this.field_200433_a.func_200391_b().resolve("data/" + id.func_110624_b() + "/tags/items/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Applied Energistics 2 Item Tags";
    }
}

