/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.entity.AEBaseItemEntity;
import java.util.Date;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public final class SingularityEntity
extends AEBaseItemEntity {
    private static final ResourceLocation TAG_ENDER_PEARL = new ResourceLocation("forge:ender_pearls");
    public static EntityType<SingularityEntity> TYPE;
    private static int randTickSeed;

    public SingularityEntity(EntityType<? extends SingularityEntity> entityType, World w) {
        super(entityType, w);
    }

    public SingularityEntity(World w, double x, double y, double z, ItemStack is) {
        super(TYPE, w, x, y, z, is);
    }

    public boolean func_70097_a(DamageSource src, float dmg) {
        if (src.func_94541_c()) {
            this.doExplosion();
            return false;
        }
        return super.func_70097_a(src, dmg);
    }

    private void doExplosion() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_SINGULARITY)) {
            return;
        }
        ItemStack item = this.func_92059_d();
        IMaterials materials = Api.instance().definitions().materials();
        if (materials.singularity().isSameAs(item)) {
            AxisAlignedBB region = new AxisAlignedBB(this.func_226277_ct_() - 4.0, this.func_226278_cu_() - 4.0, this.func_226281_cx_() - 4.0, this.func_226277_ct_() + 4.0, this.func_226278_cu_() + 4.0, this.func_226281_cx_() + 4.0);
            List<Entity> l = this.getCheckedEntitiesWithinAABBExcludingEntity(region);
            for (Entity e : l) {
                ItemStack other;
                if (!(e instanceof ItemEntity) || (other = ((ItemEntity)e).func_92059_d()).func_190926_b()) continue;
                boolean matches = false;
                if (materials.enderDust().isSameAs(other)) {
                    matches = true;
                }
                if (!matches && other.func_77973_b().getTags().contains(TAG_ENDER_PEARL)) {
                    matches = true;
                }
                if (!matches) continue;
                while (item.func_190916_E() > 0 && other.func_190916_E() > 0) {
                    other.func_190917_f(-1);
                    if (other.func_190916_E() == 0) {
                        e.func_70106_y();
                    }
                    materials.qESingularity().maybeStack(2).ifPresent(singularityStack -> {
                        CompoundNBT cmp = singularityStack.func_196082_o();
                        cmp.func_74772_a("freq", new Date().getTime() * 100L + (long)(randTickSeed % 100));
                        ++randTickSeed;
                        item.func_190917_f(-1);
                        SingularityEntity entity = new SingularityEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (ItemStack)singularityStack);
                        this.field_70170_p.func_217376_c((Entity)entity);
                    });
                }
                if (item.func_190916_E() > 0) continue;
                this.func_70106_y();
            }
        }
    }

    static {
        randTickSeed = 0;
    }
}

