/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.IIngredientSupplier;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FluidSlotPacket;
import appeng.fluids.client.gui.FluidBlitter;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidSlotWidget
extends CustomSlotWidget
implements IIngredientSupplier {
    private final IAEFluidTank fluids;

    public FluidSlotWidget(IAEFluidTank fluids, int slot) {
        super(slot);
        this.fluids = fluids;
    }

    @Override
    public void drawContent(MatrixStack matrixStack, Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fs = this.getFluidStack();
        if (fs != null) {
            FluidBlitter.create(fs.getFluidStack()).dest(this.getTooltipAreaX(), this.getTooltipAreaY(), this.getTooltipAreaWidth(), this.getTooltipAreaHeight()).blit(matrixStack, this.func_230927_p_());
        }
    }

    @Override
    public boolean canClick(PlayerEntity player) {
        ItemStack mouseStack = player.field_71071_by.func_70445_o();
        return mouseStack.func_190926_b() || mouseStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @Override
    public void slotClicked(ItemStack clickStack, int mouseButton) {
        if (clickStack.func_190926_b() || mouseButton == 1) {
            this.setFluidStack(null);
        } else if (mouseButton == 0) {
            Optional fluidOpt = FluidUtil.getFluidContained((ItemStack)clickStack);
            fluidOpt.ifPresent(fluid -> this.setFluidStack(AEFluidStack.fromFluidStack(fluid)));
        }
    }

    @Override
    public List<ITextComponent> getTooltipMessage() {
        IAEFluidStack fluid = this.getFluidStack();
        if (fluid != null) {
            return Collections.singletonList(new TranslationTextComponent(fluid.getFluidStack().getTranslationKey()));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public IAEFluidStack getFluidStack() {
        return this.fluids.getFluidInSlot(this.getId());
    }

    public void setFluidStack(IAEFluidStack stack) {
        this.fluids.setFluidInSlot(this.getId(), stack);
        NetworkHandler.instance().sendToServer(new FluidSlotPacket(Collections.singletonMap(this.getId(), this.getFluidStack())));
    }

    @Override
    @Nullable
    public FluidStack getFluidIngredient() {
        IAEFluidStack fluidStack = this.getFluidStack();
        if (fluidStack != null) {
            return fluidStack.getFluidStack();
        }
        return null;
    }
}

