/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.IConfigManager;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.fluids.container.FluidConfigurableContainer;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.FluidSyncHelper;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.util.IAEFluidTank;
import java.util.Collections;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;

public class FluidInterfaceContainer
extends FluidConfigurableContainer {
    public static final ContainerType<FluidInterfaceContainer> TYPE = ContainerTypeBuilder.create(FluidInterfaceContainer::new, IFluidInterfaceHost.class).requirePermission(SecurityPermissions.BUILD).build("fluid_interface");
    private final DualityFluidInterface myDuality;
    private final FluidSyncHelper tankSync;

    public FluidInterfaceContainer(int id, PlayerInventory ip, IFluidInterfaceHost te) {
        super(TYPE, id, ip, te.getDualityFluidInterface().getHost());
        this.myDuality = te.getDualityFluidInterface();
        this.tankSync = new FluidSyncHelper(this.myDuality.getTanks(), 6);
    }

    public IAEFluidTank getTanks() {
        return this.myDuality.getTanks();
    }

    @Override
    public IAEFluidTank getFluidConfigInventory() {
        return this.myDuality.getConfig();
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.tankSync.sendDiff(this.field_75149_d);
        }
        super.func_75142_b();
    }

    @Override
    protected void setupConfig() {
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.tankSync.sendFull(Collections.singleton(listener));
    }

    @Override
    public void receiveFluidSlots(Map<Integer, IAEFluidStack> fluids) {
        super.receiveFluidSlots(fluids);
        this.tankSync.readPacket(fluids);
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 0;
    }

    @Override
    public boolean hasToolbox() {
        return false;
    }
}

