/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridStorage;
import appeng.core.worlddata.WorldData;
import appeng.me.Grid;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundNBT;

public class GridStorage
implements IGridStorage {
    private final long myID;
    private final CompoundNBT data;
    private final WeakHashMap<GridStorage, Boolean> divided = new WeakHashMap();
    private WeakReference<IGrid> internalGrid = null;

    public GridStorage(long id) {
        this.myID = id;
        this.data = new CompoundNBT();
    }

    public GridStorage(long id, CompoundNBT data) {
        this.myID = id;
        this.data = data;
    }

    public GridStorage() {
        this.myID = 0L;
        this.data = new CompoundNBT();
    }

    public void saveState() {
        Grid currentGrid = (Grid)this.getGrid();
        if (currentGrid != null) {
            currentGrid.saveState();
        }
    }

    public IGrid getGrid() {
        return this.internalGrid == null ? null : (IGrid)this.internalGrid.get();
    }

    void setGrid(IGrid grid) {
        this.internalGrid = new WeakReference<IGrid>(grid);
    }

    @Override
    public CompoundNBT dataObject() {
        return this.data;
    }

    @Override
    public long getID() {
        return this.myID;
    }

    void addDivided(GridStorage gs) {
        this.divided.put(gs, true);
    }

    boolean hasDivided(GridStorage myStorage) {
        return this.divided.containsKey(myStorage);
    }

    void remove() {
        WorldData.instance().storageData().destroyGridStorage(this.myID);
    }
}

