/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.capabilities.Capabilities;
import appeng.helpers.ForgeEnergyAdapter;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.tile.powersink.IExternalPowerSink;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyAcceptorPart
extends AEBasePart
implements IExternalPowerSink {
    @PartModels
    private static final IPartModel MODELS = new PartModel(new ResourceLocation("appliedenergistics2", "part/energy_acceptor"));
    private ForgeEnergyAdapter forgeEnergyAdapter;
    private LazyOptional<ForgeEnergyAdapter> forgeEnergyAdapterOptional;

    public EnergyAcceptorPart(ItemStack is) {
        super(is);
        this.getProxy().setIdlePowerUsage(0.0);
        this.forgeEnergyAdapter = new ForgeEnergyAdapter(this);
        this.forgeEnergyAdapterOptional = LazyOptional.of(() -> this.forgeEnergyAdapter);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (capability == Capabilities.FORGE_ENERGY) {
            return this.forgeEnergyAdapterOptional;
        }
        return super.getCapability(capability);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.GLASS;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS;
    }

    @Override
    public final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            return grid.getEnergyDemand(maxRequired);
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @Override
    public final double injectExternalPower(PowerUnits input, double amt, Actionable mode) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), mode));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double leftOver = grid.injectPower(power, mode);
            return leftOver;
        }
        catch (GridAccessException e) {
            return power;
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        return amt;
    }

    @Override
    public final double getAEMaxPower() {
        return 0.0;
    }

    @Override
    public final double getAECurrentPower() {
        return 0.0;
    }

    @Override
    public final boolean isAEPublicPowerStorage() {
        return false;
    }

    @Override
    public final AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return 0.0;
    }
}

