/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PTunnelPart;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class CapabilityP2PTunnelPart<P extends CapabilityP2PTunnelPart<P, C>, C>
extends P2PTunnelPart<P> {
    private final Capability<C> capability;
    private boolean inBlockUpdate = false;
    private int accessDepth = 0;
    private final CapabilityGuard capabilityGuard = new CapabilityGuard();
    private final EmptyCapabilityGuard emptyCapabilityGuard = new EmptyCapabilityGuard();
    protected C inputHandler;
    protected C outputHandler;
    protected C emptyHandler;

    public CapabilityP2PTunnelPart(ItemStack is, Capability<C> capability) {
        super(is);
        this.capability = capability;
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public final <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == this.capability) {
            if (this.isOutput()) {
                return LazyOptional.of(() -> this.outputHandler).cast();
            }
            return LazyOptional.of(() -> this.inputHandler).cast();
        }
        return LazyOptional.empty();
    }

    protected final CapabilityGuard getAdjacentCapability() {
        ++this.accessDepth;
        return this.capabilityGuard;
    }

    protected final CapabilityGuard getInputCapability() {
        CapabilityP2PTunnelPart input = (CapabilityP2PTunnelPart)this.getInput();
        return input == null ? this.emptyCapabilityGuard : input.getAdjacentCapability();
    }

    private BlockPos getFacingPos() {
        return this.getHost().getLocation().getPos().func_177972_a(this.getSide().getFacing());
    }

    protected void sendBlockUpdate() {
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                TileEntity self = this.getTile();
                self.func_145831_w().func_195593_d(self.func_174877_v(), Blocks.field_150350_a);
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        this.sendBlockUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        block10: {
            if (!this.getFacingPos().equals((Object)neighbor)) {
                return;
            }
            if (!this.inBlockUpdate) {
                this.inBlockUpdate = true;
                try {
                    if (this.isOutput()) {
                        CapabilityP2PTunnelPart input = (CapabilityP2PTunnelPart)this.getInput();
                        if (input != null) {
                            input.sendBlockUpdate();
                        }
                        break block10;
                    }
                    try {
                        for (CapabilityP2PTunnelPart output : this.getOutputs()) {
                            output.sendBlockUpdate();
                        }
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                finally {
                    this.inBlockUpdate = false;
                }
            }
        }
    }

    protected class EmptyCapabilityGuard
    extends CapabilityGuard
    implements AutoCloseable {
        protected EmptyCapabilityGuard() {
        }

        @Override
        public void close() {
        }

        @Override
        protected C get() {
            return CapabilityP2PTunnelPart.this.emptyHandler;
        }
    }

    protected class CapabilityGuard
    implements AutoCloseable {
        protected CapabilityGuard() {
        }

        protected C get() {
            if (CapabilityP2PTunnelPart.this.accessDepth == 0) {
                throw new IllegalStateException("get was called after closing the wrapper");
            }
            if (CapabilityP2PTunnelPart.this.accessDepth == 1) {
                TileEntity self;
                TileEntity te;
                if (CapabilityP2PTunnelPart.this.isActive() && (te = (self = CapabilityP2PTunnelPart.this.getTile()).func_145831_w().func_175625_s(CapabilityP2PTunnelPart.this.getFacingPos())) != null) {
                    return te.getCapability(CapabilityP2PTunnelPart.this.capability, CapabilityP2PTunnelPart.this.getSide().getOpposite().getFacing()).orElse(CapabilityP2PTunnelPart.this.emptyHandler);
                }
                return CapabilityP2PTunnelPart.this.emptyHandler;
            }
            return CapabilityP2PTunnelPart.this.emptyHandler;
        }

        @Override
        public void close() {
            if (--CapabilityP2PTunnelPart.this.accessDepth < 0) {
                throw new IllegalStateException("Close has been called multiple times");
            }
        }
    }
}

