/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.core.AppEng;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntropyRecipe
implements IRecipe<IInventory> {
    public static final ResourceLocation TYPE_ID = AppEng.makeId("entropy");
    public static final IRecipeType<EntropyRecipe> TYPE = IRecipeType.func_222147_a((String)TYPE_ID.toString());
    @Nonnull
    private final ResourceLocation id;
    @Nonnull
    private final EntropyMode mode;
    @Nullable
    private final Block inputBlock;
    @Nonnull
    private final List<StateMatcher> inputBlockMatchers;
    @Nullable
    private final Fluid inputFluid;
    @Nonnull
    private final List<StateMatcher> inputFluidMatchers;
    @Nullable
    private final Block outputBlock;
    @Nonnull
    private final List<StateApplier<?>> outputBlockStateAppliers;
    private final boolean outputBlockKeep;
    @Nullable
    private final Fluid outputFluid;
    @Nonnull
    private final List<StateApplier<?>> outputFluidStateAppliers;
    private final boolean outputFluidKeep;
    @Nonnull
    private final List<ItemStack> drops;

    public EntropyRecipe(ResourceLocation id, EntropyMode mode, Block inputBlock, List<StateMatcher> inputBlockMatchers, Fluid inputFluid, List<StateMatcher> inputFluidMatchers, Block outputBlock, List<StateApplier<?>> outputBlockStateAppliers, boolean outputBlockKeep, Fluid outputFluid, List<StateApplier<?>> outputFluidStateAppliers, boolean outputFluidKeep, List<ItemStack> drops) {
        Preconditions.checkArgument((inputBlock != null || inputFluid != null ? 1 : 0) != 0, (Object)"One of inputBlock or inputFluid must not be null");
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.mode = Objects.requireNonNull(mode, "mode must not be null");
        this.inputBlock = inputBlock;
        this.inputBlockMatchers = Objects.requireNonNull(inputBlockMatchers, "inputBlockMatchers must be not null");
        this.inputFluid = inputFluid;
        this.inputFluidMatchers = Objects.requireNonNull(inputFluidMatchers, "inputFluidMatchers must be not null");
        this.outputBlock = outputBlock;
        this.outputBlockStateAppliers = Objects.requireNonNull(outputBlockStateAppliers, "outputBlockStateAppliers must be not null");
        this.outputBlockKeep = outputBlockKeep;
        this.outputFluid = outputFluid;
        this.outputFluidStateAppliers = Objects.requireNonNull(outputFluidStateAppliers, "outputFluidStateAppliers must be not null");
        this.outputFluidKeep = outputFluidKeep;
        this.drops = Objects.requireNonNull(drops, "drops must not be null");
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return EntropyRecipeSerializer.INSTANCE;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191196_a();
    }

    @Nonnull
    public EntropyMode getMode() {
        return this.mode;
    }

    @Nullable
    public Block getInputBlock() {
        return this.inputBlock;
    }

    @Nullable
    public Fluid getInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public Block getOutputBlock() {
        return this.outputBlock;
    }

    public boolean getOutputBlockKeep() {
        return this.outputBlockKeep;
    }

    @Nullable
    public BlockState getOutputBlockState(BlockState originalBlockState) {
        if (this.getOutputBlock() == null) {
            return null;
        }
        BlockState state = this.getOutputBlock().func_176223_P();
        if (this.outputBlockKeep) {
            for (Property property : originalBlockState.func_235904_r_()) {
                state = EntropyRecipe.copyProperty(originalBlockState, state, property);
            }
        }
        for (StateApplier stateApplier : this.outputBlockStateAppliers) {
            state = stateApplier.apply(state);
        }
        return state;
    }

    @Nullable
    public Fluid getOutputFluid() {
        return this.outputFluid;
    }

    public boolean getOutputFluidKeep() {
        return this.outputFluidKeep;
    }

    @Nullable
    public FluidState getOutputFluidState(FluidState originalFluidState) {
        if (this.getOutputFluid() == null) {
            return null;
        }
        FluidState state = this.getOutputFluid().func_207188_f();
        if (this.outputFluidKeep) {
            for (Property property : originalFluidState.func_235904_r_()) {
                state = EntropyRecipe.copyProperty(originalFluidState, state, property);
            }
        }
        for (StateApplier stateApplier : this.outputFluidStateAppliers) {
            state = stateApplier.apply(state);
        }
        return state;
    }

    @Nonnull
    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public boolean matches(EntropyMode mode, BlockState blockState, FluidState fluidState) {
        if (this.getMode() != mode) {
            return false;
        }
        if (blockState.func_177230_c() != this.getInputBlock() && this.getInputBlock() != null) {
            return false;
        }
        if (fluidState.func_206886_c() != this.getInputFluid() && this.getInputFluid() != null) {
            return false;
        }
        boolean isValid = true;
        if (fluidState.func_206886_c() == this.getInputFluid()) {
            isValid = this.inputFluidMatchers.stream().allMatch(m -> m.matches((StateHolder<?, ?>)fluidState));
        }
        return isValid;
    }

    @Nonnull
    List<StateMatcher> getInputBlockMatchers() {
        return this.inputBlockMatchers;
    }

    @Nonnull
    List<StateMatcher> getInputFluidMatchers() {
        return this.inputFluidMatchers;
    }

    @Nonnull
    List<StateApplier<?>> getOutputBlockStateAppliers() {
        return this.outputBlockStateAppliers;
    }

    @Nonnull
    List<StateApplier<?>> getOutputFluidStateAppliers() {
        return this.outputFluidStateAppliers;
    }

    private static <T extends Comparable<T>, SH extends StateHolder<?, SH>> SH copyProperty(SH from, SH to, Property<T> property) {
        if (to.func_235901_b_(property)) {
            return (SH)((StateHolder)to.func_206870_a(property, from.func_177229_b(property)));
        }
        return to;
    }
}

