/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class RangeValueMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final Property<T> property;
    private final T minValue;
    private final T maxValue;

    private RangeValueMatcher(Property<T> property, String minValueName, String maxValueName) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.minValue = PropertyUtils.getRequiredPropertyValue(property, minValueName);
        this.maxValue = PropertyUtils.getRequiredPropertyValue(property, maxValueName);
    }

    @Override
    public boolean matches(StateHolder<?, ?> state) {
        Comparable value = state.func_177229_b(this.property);
        return value.compareTo(this.minValue) >= 0 && value.compareTo(this.maxValue) <= 0;
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)StateMatcher.MatcherType.RANGE);
        buffer.func_180714_a(this.property.func_177701_a());
        buffer.func_180714_a(this.property.func_177702_a(this.minValue));
        buffer.func_180714_a(this.property.func_177702_a(this.maxValue));
    }

    public static StateMatcher create(StateContainer<?, ?> stateContainer, String propertyName, String minValueName, String maxValueName) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateContainer, propertyName);
        return new RangeValueMatcher(property, minValueName, maxValueName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static StateMatcher readFromPacket(StateContainer<?, ?> stateContainer, PacketBuffer buffer) {
        String propertyName = buffer.func_218666_n();
        String minName = buffer.func_218666_n();
        String maxName = buffer.func_218666_n();
        return RangeValueMatcher.create(stateContainer, propertyName, minName, maxName);
    }
}

