/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.definitions.IComparableDefinition;
import appeng.api.definitions.IDefinitions;
import appeng.core.Api;
import appeng.items.parts.FacadeItem;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class FacadeRecipe
extends SpecialRecipe {
    public static SpecialRecipeSerializer<FacadeRecipe> SERIALIZER = null;
    private final IComparableDefinition anchor;
    private final FacadeItem facade;

    public FacadeRecipe(ResourceLocation id, FacadeItem facade) {
        super(id);
        this.facade = facade;
        IDefinitions definitions = Api.instance().definitions();
        this.anchor = definitions.parts().cableAnchor();
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World w) {
        return !this.getOutput((IInventory)inv, false).func_190926_b();
    }

    @Nonnull
    private ItemStack getOutput(IInventory inv, boolean createFacade) {
        if (inv.func_70301_a(0).func_190926_b() && inv.func_70301_a(2).func_190926_b() && inv.func_70301_a(6).func_190926_b() && inv.func_70301_a(8).func_190926_b() && this.anchor.isSameAs(inv.func_70301_a(1)) && this.anchor.isSameAs(inv.func_70301_a(3)) && this.anchor.isSameAs(inv.func_70301_a(5)) && this.anchor.isSameAs(inv.func_70301_a(7))) {
            ItemStack facades = this.facade.createFacadeForItem(inv.func_70301_a(4), !createFacade);
            if (!facades.func_190926_b() && createFacade) {
                facades.func_190920_e(4);
            }
            return facades;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        return this.getOutput((IInventory)inv, true);
    }

    public boolean func_194133_a(int i, int i1) {
        return false;
    }

    @Nonnull
    public IRecipeSerializer<FacadeRecipe> func_199559_b() {
        return FacadeRecipe.getSerializer(this.facade);
    }

    public static IRecipeSerializer<FacadeRecipe> getSerializer(FacadeItem facade) {
        if (SERIALIZER == null) {
            SERIALIZER = new SpecialRecipeSerializer(id -> new FacadeRecipe((ResourceLocation)id, facade));
            SERIALIZER.setRegistryName(new ResourceLocation("appliedenergistics2", "facade"));
        }
        return SERIALIZER;
    }
}

