/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public final class PlacedMeteoriteSettings {
    private final BlockPos pos;
    private final float meteoriteRadius;
    private final CraterType craterType;
    private final FalloutMode fallout;
    private final boolean pureCrater;
    private final boolean craterLake;

    public PlacedMeteoriteSettings(BlockPos pos, float meteoriteRadius, CraterType craterType, FalloutMode fallout, boolean pureCrater, boolean craterLake) {
        this.pos = pos;
        this.craterType = craterType;
        this.meteoriteRadius = meteoriteRadius;
        this.fallout = fallout;
        this.pureCrater = pureCrater;
        this.craterLake = craterLake;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public CraterType getCraterType() {
        return this.craterType;
    }

    public float getMeteoriteRadius() {
        return this.meteoriteRadius;
    }

    public FalloutMode getFallout() {
        return this.fallout;
    }

    public boolean shouldPlaceCrater() {
        return this.craterType != CraterType.NONE;
    }

    public boolean isPureCrater() {
        return this.pureCrater;
    }

    public boolean isCraterLake() {
        return this.craterLake;
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74772_a("c", this.pos.func_218275_a());
        tag.func_74776_a("r", this.meteoriteRadius);
        tag.func_74774_a("t", (byte)this.craterType.ordinal());
        tag.func_74774_a("f", (byte)this.fallout.ordinal());
        tag.func_74757_a("p", this.pureCrater);
        tag.func_74757_a("l", this.craterLake);
        return tag;
    }

    public static PlacedMeteoriteSettings read(CompoundNBT tag) {
        BlockPos pos = BlockPos.func_218283_e((long)tag.func_74763_f("c"));
        float meteoriteRadius = tag.func_74760_g("r");
        CraterType craterType = CraterType.values()[tag.func_74771_c("t")];
        FalloutMode fallout = FalloutMode.values()[tag.func_74771_c("f")];
        boolean pureCrater = tag.func_74767_n("p");
        boolean craterLake = tag.func_74767_n("l");
        return new PlacedMeteoriteSettings(pos, meteoriteRadius, craterType, fallout, pureCrater, craterLake);
    }

    public String toString() {
        return "PlacedMeteoriteSettings [pos=" + this.pos + ", meteoriteRadius=" + this.meteoriteRadius + ", craterType=" + (Object)((Object)this.craterType) + ", fallout=" + (Object)((Object)this.fallout) + ", pureCrater=" + this.pureCrater + ", craterLake=" + this.craterLake + "]";
    }
}

