/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class HUDHandlerBlocks
implements IComponentProvider {
    static final IComponentProvider INSTANCE = new HUDHandlerBlocks();
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    static final ResourceLocation MOD_NAME_TAG = new ResourceLocation("waila", "mod_name");

    @Override
    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockState().func_185904_a().func_76224_d()) {
            return;
        }
        ((ITaggableList)tooltip).setTag(OBJECT_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getBlockName(), accessor.getStack().func_200301_q().getString())));
        if (config.get(PluginCore.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(REGISTRY_NAME_TAG, new StringTextComponent(accessor.getBlock().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get(PluginCore.CONFIG_SHOW_STATES)) {
            BlockState state = accessor.getBlockState();
            state.func_235904_r_().forEach(p -> {
                Comparable value = state.func_177229_b(p);
                IFormattableTextComponent valueText = new StringTextComponent(value.toString()).func_240699_a_(p instanceof BooleanProperty ? (value == Boolean.TRUE ? TextFormatting.GREEN : TextFormatting.RED) : TextFormatting.RESET);
                tooltip.add((ITextComponent)new StringTextComponent(p.func_177701_a() + ":").func_230529_a_((ITextComponent)valueText));
            });
        }
    }

    @Override
    public void appendTail(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        String modName = ModIdentification.getModInfo(accessor.getStack()).getName();
        if (!Strings.isNullOrEmpty((String)modName)) {
            modName = String.format(Waila.CONFIG.get().getFormatting().getModName(), modName);
            ((ITaggableList)tooltip).setTag(MOD_NAME_TAG, new StringTextComponent(modName));
        }
    }
}

