/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DisplayUtil {
    private static final String[] NUM_SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    private static final Minecraft CLIENT = Minecraft.func_71410_x();

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.func_175599_af().func_175042_a(stack, x, y);
            ItemStack overlayRender = stack.func_77946_l();
            overlayRender.func_190920_e(1);
            CLIENT.func_175599_af().func_180453_a(DisplayUtil.CLIENT.field_71466_p, overlayRender, x, y, null);
            DisplayUtil.renderStackSize(new MatrixStack(), DisplayUtil.CLIENT.field_71466_p, stack, x, y);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void renderStackSize(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        if (!stack.func_190926_b() && stack.func_190916_E() != 1) {
            String s = DisplayUtil.shortHandNumber(stack.func_190916_E());
            if (stack.func_190916_E() < 1) {
                s = TextFormatting.RED + String.valueOf(stack.func_190916_E());
            }
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.translated((double)0.0, (double)0.0, (double)(Minecraft.func_71410_x().func_175599_af().field_77023_b + 200.0f));
            fr.func_238405_a_(matrixStack, s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
        }
    }

    private static String shortHandNumber(Number number) {
        String shorthand = new DecimalFormat("##0E0").format(number);
        shorthand = shorthand.replaceAll("E[0-9]", NUM_SUFFIXES[Character.getNumericValue(shorthand.charAt(shorthand.length() - 1)) / 3]);
        while (shorthand.length() > 4 || shorthand.matches("[0-9]+\\.[a-z]")) {
            shorthand = shorthand.substring(0, shorthand.length() - 2) + shorthand.substring(shorthand.length() - 1);
        }
        return shorthand;
    }

    public static void enable3DRender() {
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float zLevel = 0.0f;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)(left + right), (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        buffer.func_225582_a_((double)left, (double)top, (double)zLevel).func_227885_a_(f1, f2, f3, f).func_181675_d();
        buffer.func_225582_a_((double)left, (double)(top + bottom), (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        buffer.func_225582_a_((double)(left + right), (double)(top + bottom), (double)zLevel).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_((float)textureX * f, (float)(textureY + th) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(textureX + tw) * f, (float)(textureY + th) * f1).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_((float)(textureX + tw) * f, (float)textureY * f1).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_((float)textureX * f, (float)textureY * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static List<ITextComponent> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<ITextComponent> namelist = null;
        try {
            namelist = itemstack.func_82840_a((PlayerEntity)DisplayUtil.CLIENT.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<ITextComponent>();
        }
        if (namelist.isEmpty()) {
            namelist.add((ITextComponent)new StringTextComponent("Unnamed"));
        }
        namelist.set(0, (ITextComponent)new StringTextComponent(itemstack.func_77953_t().field_77937_e.toString() + namelist.get(0)));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (ITextComponent)namelist.get(i));
        }
        return namelist;
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CLIENT.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        if (icon == null) {
            return;
        }
        RenderSystem.enableAlphaTest();
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
        RenderSystem.disableAlphaTest();
    }
}

