/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.config.ConfigurationHandler;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import com.infinityraider.infinitylib.network.NetworkWrapper;
import com.infinityraider.infinitylib.proxy.IProxy;
import com.infinityraider.infinitylib.proxy.base.IProxyBase;
import com.infinityraider.infinitylib.render.model.InfModelLoader;
import com.infinityraider.infinitylib.utility.InfinityLogger;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class InfinityMod<P extends IProxyBase<C>, C extends ConfigurationHandler.SidedModConfig> {
    private final InfinityLogger logger;
    private final NetworkWrapper networkWrapper;
    private final P proxy;
    private final ConfigurationHandler<C> config;

    public InfinityMod() {
        this.onModConstructed();
        this.logger = new InfinityLogger(this);
        this.networkWrapper = new NetworkWrapper(this);
        this.proxy = this.createProxy();
        this.config = new ConfigurationHandler(ModLoadingContext.get(), this.proxy().getConfigConstructor(), this);
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus bus = context.getModEventBus();
        bus.addListener(this::onCommonSetupEvent);
        bus.addListener(this::onClientSetupEvent);
        bus.addListener(this::onDedicatedServerSetupEvent);
        bus.addListener(this::onInterModEnqueueEvent);
        bus.addListener(this::onInterModProcessEvent);
        bus.addListener(this::onModLoadCompleteEvent);
        this.proxy().registerFMLEventHandlers(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.proxy().activateRequiredModules();
        ((IProxy)InfinityLib.instance.proxy()).registerRegistrables(this);
        this.initializeAPI();
    }

    private P createProxy() {
        IProxyBase proxy = (IProxyBase)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> this::createClientProxy);
        if (proxy == null) {
            proxy = (IProxyBase)DistExecutor.unsafeCallWhenOn((Dist)Dist.DEDICATED_SERVER, () -> this::createServerProxy);
        }
        if (proxy == null) {
            throw new RuntimeException("Failed to create SidedProxy for mod " + this.getModId() + " on side: " + FMLEnvironment.dist.name());
        }
        return (P)proxy;
    }

    private void init() {
        this.proxy().registerEventHandlers();
        this.proxy().registerCapabilities();
        this.networkWrapper.init();
    }

    private void initClient() {
        ((IProxy)InfinityLib.instance.proxy()).registerRenderers(this);
    }

    public final InfinityLogger getLogger() {
        return this.logger;
    }

    public final INetworkWrapper getNetworkWrapper() {
        return this.networkWrapper;
    }

    public final P proxy() {
        return this.proxy;
    }

    public final C getConfig() {
        return this.config.getConfig();
    }

    public abstract String getModId();

    protected abstract void onModConstructed();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract P createClientProxy();

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    protected abstract P createServerProxy();

    public void registerMessages(INetworkWrapper wrapper) {
    }

    public void initializeAPI() {
    }

    public Object getModBlockRegistry() {
        return null;
    }

    public Object getModTileRegistry() {
        return null;
    }

    public Object getModItemRegistry() {
        return null;
    }

    public Object getModFluidRegistry() {
        return null;
    }

    public Object getModBiomeRegistry() {
        return null;
    }

    public Object getModEnchantmentRegistry() {
        return null;
    }

    public Object getModEntityRegistry() {
        return null;
    }

    public Object getModEffectRegistry() {
        return null;
    }

    public Object getModPotionTypeRegistry() {
        return null;
    }

    public Object getModSoundRegistry() {
        return null;
    }

    public Object getModParticleRegistry() {
        return null;
    }

    public Object getModContainerRegistry() {
        return null;
    }

    public Object getModRecipeSerializerRegistry() {
        return null;
    }

    public Object getModLootModifierSerializerRegistry() {
        return null;
    }

    public Object getStructureRegistry() {
        return null;
    }

    public Object getModVillagerProfessionRegistry() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<InfModelLoader<?>> getModModelLoaders() {
        return ImmutableList.of();
    }

    public final void onCommonSetupEvent(FMLCommonSetupEvent event) {
        this.init();
        this.proxy().onCommonSetupEvent(event);
    }

    public final void onClientSetupEvent(FMLClientSetupEvent event) {
        this.initClient();
        this.proxy().onClientSetupEvent(event);
    }

    public final void onDedicatedServerSetupEvent(FMLDedicatedServerSetupEvent event) {
        this.proxy().onDedicatedServerSetupEvent(event);
    }

    public final void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        this.proxy().onInterModEnqueueEvent(event);
    }

    public final void onInterModProcessEvent(InterModProcessEvent event) {
        this.proxy().onInterModProcessEvent(event);
    }

    public final void onModLoadCompleteEvent(FMLLoadCompleteEvent event) {
        this.proxy().onModLoadCompleteEvent(event);
    }

    @SubscribeEvent
    public final void onServerStartingEvent(FMLServerStartingEvent event) {
        this.proxy().onServerStartingEvent(event);
    }

    @SubscribeEvent
    public final void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        this.proxy().onServerAboutToStartEvent(event);
    }

    @SubscribeEvent
    public final void onServerStoppingEvent(FMLServerStoppingEvent event) {
        this.proxy().onServerStoppingEvent(event);
    }

    @SubscribeEvent
    public final void onServerStoppedEvent(FMLServerStoppedEvent event) {
        this.proxy().onServerStoppedEvent(event);
    }

    public final Dist getPhysicalSide() {
        return this.proxy().getPhysicalSide();
    }

    public final LogicalSide getEffectiveSide() {
        return this.proxy().getLogicalSide();
    }

    public final MinecraftServer getMinecraftServer() {
        return this.proxy().getMinecraftServer();
    }

    public final PlayerEntity getClientPlayer() {
        return this.proxy().getClientPlayer();
    }

    public final World getClientWorld() {
        return this.proxy().getClientWorld();
    }

    public final World getWorldFromDimension(RegistryKey<World> dimension) {
        return this.proxy().getWorldFromDimension(dimension);
    }

    public final Entity getEntityById(World world, int id) {
        return this.proxy().getEntityById(world, id);
    }

    public final Entity getEntityById(RegistryKey<World> dimension, int id) {
        return this.proxy().getEntityById(dimension, id);
    }

    public final void queueTask(Runnable task) {
        this.proxy().queueTask(task);
    }

    public final void registerEventHandler(Object handler) {
        this.proxy().registerEventHandler(handler);
    }
}

