/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.container;

import com.infinityraider.infinitylib.container.ContainerBase;
import com.infinityraider.infinitylib.container.IInfinityContainerType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.fml.network.IContainerFactory;

public class InfinityContainerType<T extends ContainerBase>
extends ContainerType<T>
implements IInfinityContainerType {
    private final String name;
    private final IInfinityContainerType.IGuiFactory<T> guiFactory;

    private InfinityContainerType(String name, IContainerFactory<T> factory, IInfinityContainerType.IGuiFactory<T> guiFactory) {
        super(factory);
        this.name = name;
        this.guiFactory = guiFactory;
    }

    @Override
    @Nonnull
    public String getInternalName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public static <T extends ContainerBase> Builder<T> builder(String name, IContainerFactory<T> factory) {
        return new Builder(name, factory);
    }

    @Nullable
    public IInfinityContainerType.IGuiFactory<T> getGuiFactory() {
        return this.guiFactory;
    }

    public static final class Builder<T extends ContainerBase> {
        private final String name;
        private final IContainerFactory<T> factory;
        private IInfinityContainerType.IGuiFactory<T> guiFactory;

        private Builder(String name, IContainerFactory<T> factory) {
            this.name = name;
            this.factory = factory;
        }

        public Builder<T> setGuiFactory(IInfinityContainerType.IGuiFactory<T> factory) {
            this.guiFactory = factory;
            return this;
        }

        public InfinityContainerType<T> build() {
            return new InfinityContainerType(this.name, this.factory, this.guiFactory);
        }
    }
}

