/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.entity.EntityTypeBase;
import com.infinityraider.infinitylib.entity.IInfinityLivingEntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class LivingEntityTypeBase<T extends LivingEntity>
extends EntityTypeBase<T>
implements IInfinityLivingEntityType {
    private final Supplier<AttributeModifierMap> attributeSupplier;
    private final Optional<IInfinityLivingEntityType.SpawnEggData> spawnEggData;
    private final Set<IInfinityLivingEntityType.SpawnRule> spawnRules;

    protected LivingEntityTypeBase(String name, Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, boolean p_i231489_3_, boolean summonable, boolean immuneToFire, boolean p_i231489_6_, ImmutableSet<Block> blocks, EntitySize size, int trackingRange, int updateInterval, boolean velocityUpdates, BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory, Set<Class<? extends MobEntity>> aggressors, IRenderFactory<T> renderFactory, Supplier<AttributeModifierMap> attributeSupplier, IInfinityLivingEntityType.SpawnEggData spawnEggData, Set<IInfinityLivingEntityType.SpawnRule> spawnRules) {
        super(name, entityClass, factory, classification, p_i231489_3_, summonable, immuneToFire, p_i231489_6_, blocks, size, trackingRange, updateInterval, velocityUpdates, customClientFactory, aggressors, renderFactory);
        this.attributeSupplier = attributeSupplier;
        this.spawnEggData = Optional.ofNullable(spawnEggData);
        this.spawnRules = spawnRules;
    }

    @Override
    public AttributeModifierMap createCustomAttributes() {
        return this.attributeSupplier.get();
    }

    @Override
    public Optional<IInfinityLivingEntityType.SpawnEggData> getSpawnEggData() {
        return this.spawnEggData;
    }

    @Override
    public Set<IInfinityLivingEntityType.SpawnRule> getSpawnRules() {
        return this.spawnRules;
    }

    public static <T extends LivingEntity> Builder<T> livingEntityTypeBuilder(String name, Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, EntitySize size) {
        return new Builder<T>(name, entityClass, factory, classification, size);
    }

    public static <T extends LivingEntity> EntityTypeBase.Builder<T> livingEntityTypeBuilder(String name, Class<T> entityClass, BiFunction<FMLPlayMessages.SpawnEntity, World, T> clientFactory, EntityClassification classification, EntitySize size) {
        return new Builder<T>(name, entityClass, clientFactory, classification, size);
    }

    public static class Builder<T extends LivingEntity>
    extends EntityTypeBase.Builder<T> {
        private Supplier<AttributeModifierMap> attributeSupplier;
        private IInfinityLivingEntityType.SpawnEggData spawnEggData;
        private final Set<IInfinityLivingEntityType.SpawnRule> spawnRules = Sets.newIdentityHashSet();

        protected Builder(String name, Class<T> entityClass, EntityType.IFactory<T> factory, EntityClassification classification, EntitySize size) {
            super(name, entityClass, factory, classification, size);
        }

        protected Builder(String name, Class<T> entityClass, BiFunction<FMLPlayMessages.SpawnEntity, World, T> factory, EntityClassification classification, EntitySize size) {
            super(name, entityClass, factory, classification, size);
        }

        @Override
        public LivingEntityTypeBase<T> build() {
            return new LivingEntityTypeBase(this.name, this.entityClass, this.factory, this.classification, this.serializable, this.summonable, this.immuneToFire, this.p_i231489_6_, (ImmutableSet<Block>)ImmutableSet.copyOf((Collection)this.blocks), this.size, this.trackingRange, this.updateInterval, this.velocityUpdates, this.customClientFactory, this.aggressors, this.renderFactory, this.attributeSupplier, this.spawnEggData, this.spawnRules);
        }

        public Builder<T> setAttributeSupplier(Supplier<AttributeModifierMap> attributeSupplier) {
            this.attributeSupplier = attributeSupplier;
            return this;
        }

        public Builder<T> setSpawnEggData(IInfinityLivingEntityType.SpawnEggData spawnEggData) {
            this.spawnEggData = spawnEggData;
            return this;
        }

        public Builder<T> addSpawnRule(IInfinityLivingEntityType.SpawnRule spawnRule) {
            this.spawnRules.add(spawnRule);
            return this;
        }

        public Builder<T> addSpawnRules(Collection<IInfinityLivingEntityType.SpawnRule> spawnRules) {
            this.spawnRules.addAll(spawnRules);
            return this;
        }

        public Builder<T> addSpawnRules(IInfinityLivingEntityType.SpawnRule ... spawnRules) {
            this.spawnRules.addAll(Arrays.asList(spawnRules));
            return this;
        }
    }
}

