/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.entity.ai.pathfinding;

import com.google.common.collect.Lists;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.entity.ai.pathfinding.PathCalculator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PathFindJob
extends Path {
    public static final double DEFAULT_SPEED = 1.5;
    private final MobEntity entity;
    private final double speed;
    private final PathCalculator.ITarget target;
    private final PathCalculator.IPathOptions options;
    private final ICallback callback;
    private boolean cancelled;

    public PathFindJob(MobEntity entity, PathCalculator.ITarget target, PathCalculator.IPathOptions options) {
        this(entity, 1.5, target, options);
    }

    public PathFindJob(MobEntity entity, double speed, PathCalculator.ITarget target, PathCalculator.IPathOptions options) {
        this(entity, speed, target, options, ICallback.none);
    }

    public PathFindJob(MobEntity entity, double speed, PathCalculator.ITarget target, PathCalculator.IPathOptions options, ICallback callback) {
        super((List)Lists.newArrayList((Object[])new PathPoint[]{target.getTargetPoint()}), target.getTargetPoint().func_224759_a(), false);
        this.entity = Objects.requireNonNull(entity);
        this.speed = speed;
        this.target = Objects.requireNonNull(target);
        this.options = options;
        this.callback = Objects.requireNonNull(callback);
        this.cancelled = false;
    }

    public MobEntity entity() {
        return this.entity;
    }

    public double speed() {
        return this.speed;
    }

    public PathCalculator.IPathOptions options() {
        return this.options;
    }

    public PathPoint getEntityPoint() {
        Vector3d entityPos = this.getEntityPosition();
        return new PathPoint(MathHelper.func_76128_c((double)entityPos.field_72450_a), MathHelper.func_76128_c((double)entityPos.field_72448_b), MathHelper.func_76128_c((double)entityPos.field_72449_c));
    }

    public Vector3d getEntityPosition() {
        return this.entity().func_213303_ch().func_178787_e(new Vector3d((double)((int)(this.entity().func_213311_cf() + 1.0f)) * 0.5, 0.0, (double)((int)(this.entity().func_213311_cf() + 1.0f)) * 0.5));
    }

    public boolean isValid() {
        return !this.cancelled && this.entity().func_70089_S() && this.target().isValid();
    }

    public PathFindJob cancel() {
        this.cancelled = true;
        this.entity().func_70661_as().func_75484_a(null, this.speed());
        InfinityLib.instance.queueTask(this.callback::onJobCancelled);
        return this;
    }

    public PathFindJob finish(Path path) {
        this.entity().func_70661_as().func_75484_a(path, this.speed());
        InfinityLib.instance.queueTask(() -> this.callback.onJobFinished(this.entity(), path));
        this.cancelled = true;
        return this;
    }

    public PathFindJob fail() {
        this.cancelled = true;
        this.entity().func_70661_as().func_75484_a(null, this.speed());
        InfinityLib.instance.queueTask(this.callback::onJobFailed);
        return this;
    }

    public PathCalculator.ITarget target() {
        return this.target;
    }

    public boolean canTargetMove() {
        return this.target.canTargetMove();
    }

    public boolean hasTargetChanged(Vector3d previous) {
        return this.target.hasTargetChanged(previous);
    }

    public Vector3d getTargetVector() {
        return this.target.getTarget();
    }

    public boolean canOpenDoors() {
        return this.options().canOpenDoors();
    }

    public boolean canClimbLadders() {
        return this.options().canClimbLadders();
    }

    public boolean canClimbWalls() {
        return this.options().canClimbWalls();
    }

    public boolean canSwim() {
        return this.options().canSwim();
    }

    public boolean canFly() {
        return this.options().canFly();
    }

    public int maxFallHeight() {
        return this.options().maxFallHeight();
    }

    public int maxJumpHeight() {
        return this.options().maxJumpHeight();
    }

    public void func_75875_a() {
    }

    public boolean func_75879_b() {
        return false;
    }

    @Nullable
    public PathPoint func_75870_c() {
        return this.target.getTargetPoint();
    }

    public PathPoint func_75877_a(int index) {
        return this.getEntityPoint();
    }

    public void func_186309_a(int index, PathPoint point) {
    }

    public int func_75874_d() {
        return MathHelper.func_76143_f((double)this.entity().func_213303_ch().func_72438_d(this.target.getTarget()));
    }

    public void func_215747_b(int length) {
    }

    public int func_75873_e() {
        return 0;
    }

    public void func_75872_c(int currentPathIndexIn) {
    }

    public Vector3d func_75881_a(Entity entity, int index) {
        return this.getEntityPosition();
    }

    public Vector3d func_75878_a(Entity entity) {
        return this.func_75881_a(entity, this.func_75873_e());
    }

    public boolean func_75876_a(Path other) {
        return other == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PathPoint[] func_189966_g() {
        return new PathPoint[0];
    }

    @OnlyIn(value=Dist.CLIENT)
    public PathPoint[] func_189965_h() {
        return new PathPoint[0];
    }

    public BlockPos func_224770_k() {
        return this.func_75870_c().func_224759_a();
    }

    public static interface ICallback {
        public static final ICallback none = new ICallback(){

            @Override
            public void onJobCancelled() {
            }

            @Override
            public void onJobFinished(MobEntity entity, Path path) {
            }

            @Override
            public void onJobFailed() {
            }
        };

        public void onJobCancelled();

        public void onJobFinished(MobEntity var1, Path var2);

        public void onJobFailed();
    }
}

