/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.capability.ICapabilityImplementation;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Module
implements Comparable<Module> {
    private static final HashSet<Module> activeModules = new HashSet();
    private boolean active = false;

    public static List<Module> getActiveModules() {
        return ImmutableList.copyOf(activeModules);
    }

    protected Module() {
    }

    public final void activate() {
        if (!this.active) {
            this.active = true;
            activeModules.add(this);
            this.requiredModules().forEach(Module::activate);
        }
    }

    public List<Module> requiredModules() {
        return ImmutableList.of();
    }

    public void registerMessages(INetworkWrapper wrapper) {
    }

    public List<Object> getCommonEventHandlers() {
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getClientEventHandlers() {
        return Collections.emptyList();
    }

    public List<ICapabilityImplementation<?, ?>> getCapabilities() {
        return Collections.emptyList();
    }

    public void init() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
    }

    public void postInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postInitClient() {
    }

    @Override
    public int compareTo(Module other) {
        return this.getClass().getName().compareTo(other.getClass().getName());
    }
}

