/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.keyboard;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.modules.keyboard.IKeyListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class KeyEventHandler {
    private static final KeyEventHandler INSTANCE = new KeyEventHandler();
    private final Map<Integer, KeyTracker> trackers = new HashMap<Integer, KeyTracker>();

    public static KeyEventHandler getInstance() {
        return INSTANCE;
    }

    private KeyEventHandler() {
    }

    private KeyTracker getTracker(int key) {
        if (this.trackers.containsKey(key)) {
            return this.trackers.get(key);
        }
        KeyTracker tracker = new KeyTracker(key);
        this.trackers.put(key, tracker);
        return tracker;
    }

    protected void registerListener(IKeyListener listener) {
        listener.keys().forEach(key -> this.getTracker((int)key).addListener(listener));
    }

    protected boolean isKeyPressed(int key) {
        return this.getTracker(key).isPressed();
    }

    protected boolean isKeyRepeated(int key) {
        return this.getTracker(key).isRepeated();
    }

    protected int getKeyHoldDownTime(int key) {
        return this.getTracker(key).getCount();
    }

    protected int getKeyModifier(int key) {
        return this.getTracker(key).getModifier();
    }

    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        KeyTracker tracker = this.getTracker(event.getKey());
        switch (event.getAction()) {
            case 1: {
                tracker.onPress(event.getModifiers());
                break;
            }
            case 0: {
                tracker.onRelease(event.getModifiers());
                break;
            }
            case 2: {
                tracker.onRepeat(event.getModifiers());
            }
        }
    }

    @SubscribeEvent
    public void onTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.trackers.values().forEach(KeyTracker::onTick);
        }
    }

    private static class KeyTracker {
        private final int key;
        private final Set<IKeyListener> listeners;
        private boolean pressed;
        private boolean repeated;
        private int modifier;
        private int count;

        private KeyTracker(int key) {
            this.key = key;
            this.listeners = Sets.newIdentityHashSet();
            this.modifier = -1;
            this.count = 0;
        }

        public int getKey() {
            return this.key;
        }

        public int getModifier() {
            return this.modifier;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public boolean isRepeated() {
            return this.repeated;
        }

        public KeyTracker addListener(IKeyListener listener) {
            if (listener.keys().contains(this.getKey())) {
                this.listeners.add(listener);
            }
            return this;
        }

        public void onPress(int modifier) {
            this.pressed = true;
            this.modifier = modifier;
            this.count = 0;
            this.listeners.forEach(l -> l.onKeyPress(this.getKey(), this.getModifier()));
        }

        public void onRelease(int modifier) {
            this.pressed = false;
            this.modifier = modifier;
            this.listeners.forEach(l -> l.onKeyReleased(this.getKey(), this.getModifier(), this.getCount()));
        }

        public void onRepeat(int modifier) {
            this.repeated = true;
            this.modifier = modifier;
            this.listeners.forEach(l -> l.onKeyRepeated(this.getKey(), this.getModifier()));
        }

        public void onTick() {
            if (this.isPressed()) {
                ++this.count;
                this.listeners.forEach(l -> l.whileKeyHeld(this.getKey(), this.getModifier(), this.getCount()));
            } else {
                this.count = 0;
                this.modifier = -1;
            }
            if (this.isRepeated()) {
                this.repeated = false;
                this.count = 0;
                this.modifier = -1;
            }
        }
    }
}

