/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.QuadTransformer;

@OnlyIn(value=Dist.CLIENT)
public abstract class TessellatorAbstractBase
implements ITessellator {
    private final MatrixStack matrices = new MatrixStack();
    private ITessellator.Face face = ITessellator.Face.NONE;
    private Vector3f normal = ITessellator.Defaults.NORMAL;
    private float r;
    private float g;
    private float b;
    private float a;
    private int l;
    private int o;
    private int tintIndex;
    private boolean applyDiffuseLighting;
    private QuadTransformer cachedTransformer;

    protected TessellatorAbstractBase() {
        this.setColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        this.setBrightness(0xF000000);
        this.setOverlay(ITessellator.Defaults.OVERLAY);
        this.tintIndex = -1;
        this.applyDiffuseLighting = false;
    }

    private void manipulateMatrixStack(Consumer<MatrixStack> operator) {
        this.cachedTransformer = null;
        operator.accept(this.matrices);
    }

    private MatrixStack getMatrixStack() {
        return this.matrices;
    }

    protected MatrixStack.Entry getMatrixStackEntry() {
        return this.getMatrixStack().func_227866_c_();
    }

    protected Matrix4f getCurrentMatrix() {
        return this.getMatrixStackEntry().func_227870_a_();
    }

    protected QuadTransformer getCachedQuadTransformer() {
        if (this.cachedTransformer == null) {
            this.cachedTransformer = new QuadTransformer(new TransformationMatrix(this.getCurrentMatrix()));
        }
        return this.cachedTransformer;
    }

    @Override
    public final TessellatorAbstractBase startDrawingQuads() {
        this.face = ITessellator.Face.NONE;
        this.onStartDrawingQuadsCall();
        return this;
    }

    protected abstract void onStartDrawingQuadsCall();

    @Override
    public final TessellatorAbstractBase draw() {
        this.onDrawCall();
        this.normal = ITessellator.Defaults.NORMAL;
        this.setColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        this.setBrightness(0xF000000);
        this.setOverlay(ITessellator.Defaults.OVERLAY);
        this.tintIndex = -1;
        this.applyDiffuseLighting = false;
        this.manipulateMatrixStack(MatrixStack::func_227867_d_);
        return this;
    }

    protected abstract void onDrawCall();

    @Override
    public TessellatorAbstractBase pushMatrix() {
        this.manipulateMatrixStack(MatrixStack::func_227860_a_);
        return this;
    }

    @Override
    public TessellatorAbstractBase popMatrix() {
        this.manipulateMatrixStack(MatrixStack::func_227865_b_);
        return this;
    }

    @Override
    public TessellatorAbstractBase addVertexWithUV(float x, float y, float z, TextureAtlasSprite sprite, float u, float v) {
        if (sprite == null) {
            sprite = this.getMissingSprite();
        }
        return this.addVertexWithUV(x, y, z, sprite.func_94214_a((double)u), sprite.func_94207_b((double)v));
    }

    @Override
    public abstract TessellatorAbstractBase addVertexWithUV(float var1, float var2, float var3, float var4, float var5);

    @Override
    public TessellatorAbstractBase addScaledVertexWithUV(float x, float y, float z, float u, float v) {
        return this.addVertexWithUV(x * 0.0625f, y * 0.0625f, z * 0.0625f, u, v);
    }

    @Override
    public TessellatorAbstractBase addScaledVertexWithUV(float x, float y, float z, TextureAtlasSprite icon, float u, float v) {
        return this.addVertexWithUV(x * 0.0625f, y * 0.0625f, z * 0.0625f, icon, u, v);
    }

    @Override
    public TessellatorAbstractBase drawScaledFace(float minX, float minY, float maxX, float maxY, Direction face, float offset) {
        return this.drawScaledFace(minX, minY, maxX, maxY, face, offset, minX % 17.0f, minY % 17.0f, maxX % 17.0f, maxY % 17.0f);
    }

    @Override
    public TessellatorAbstractBase drawScaledFace(float minX, float minY, float maxX, float maxY, Direction face, float offset, float u1, float v1, float u2, float v2) {
        float v1f;
        float v2f;
        float v3f;
        float v4f;
        float u1f;
        float u4f;
        float u2f;
        float u3f;
        float y1;
        float y2;
        float y3;
        float y4;
        float z3;
        float z4;
        float z1;
        float z2;
        float x2;
        float x3;
        float x1;
        float x4;
        switch (face) {
            case UP: {
                x1 = x4 = maxX;
                x2 = x3 = minX;
                z1 = z2 = minY;
                z3 = z4 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u2f = u3f = u1;
                u1f = u4f = u2;
                v3f = v4f = v2;
                v1f = v2f = v1;
                break;
            }
            case DOWN: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                z1 = z4 = minY;
                z2 = z3 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u1f = u2f = u2;
                u3f = u4f = u1;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            case WEST: {
                z1 = z2 = maxX;
                z3 = z4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1f = u2f = u2;
                u3f = u4f = u1;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            case EAST: {
                z1 = z2 = minX;
                z3 = z4 = maxX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1f = u2f = 16.0f - u1;
                u3f = u4f = 16.0f - u2;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            case NORTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = maxY;
                y2 = y3 = minY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1f = u2f = 16.0f - u2;
                u3f = u4f = 16.0f - u1;
                v1f = v4f = 16.0f - v2;
                v2f = v3f = 16.0f - v1;
                break;
            }
            case SOUTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1f = u2f = u2;
                u3f = u4f = u1;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            default: {
                return this;
            }
        }
        float rPrev = this.r;
        float gPrev = this.g;
        float bPrev = this.b;
        float aPrev = this.a;
        this.applyColorMultiplier(face);
        this.setNormal(face.func_82601_c(), face.func_96559_d(), face.func_82599_e());
        this.addScaledVertexWithUV(x1, y1, z1, u1f, v1f);
        this.addScaledVertexWithUV(x2, y2, z2, u2f, v2f);
        this.addScaledVertexWithUV(x3, y3, z3, u3f, v3f);
        this.addScaledVertexWithUV(x4, y4, z4, u4f, v4f);
        return this.setColorRGBA(rPrev, gPrev, bPrev, aPrev);
    }

    @Override
    public TessellatorAbstractBase drawScaledFace(float minX, float minY, float maxX, float maxY, Direction face, TextureAtlasSprite icon, float offset) {
        return this.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset, minX % 17.0f, minY % 17.0f, maxX % 17.0f, maxY % 17.0f);
    }

    @Override
    public TessellatorAbstractBase drawScaledFace(float minX, float minY, float maxX, float maxY, Direction face, TextureAtlasSprite icon, float offset, float u1, float v1, float u2, float v2) {
        float v1f;
        float v2f;
        float v3f;
        float v4f;
        float u1f;
        float u4f;
        float u2f;
        float u3f;
        float y1;
        float y2;
        float y3;
        float y4;
        float z3;
        float z4;
        float z1;
        float z2;
        float x2;
        float x3;
        float x1;
        float x4;
        switch (face) {
            case UP: {
                x1 = x4 = maxX;
                x2 = x3 = minX;
                z1 = z2 = minY;
                z3 = z4 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u2f = u3f = u1;
                u1f = u4f = u2;
                v3f = v4f = v2;
                v1f = v2f = v1;
                break;
            }
            case DOWN: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                z1 = z4 = minY;
                z2 = z3 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u1f = u2f = u2;
                u3f = u4f = u1;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            case WEST: {
                z1 = z2 = maxX;
                z3 = z4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1f = u2f = u2;
                u3f = u4f = u1;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            case EAST: {
                z1 = z2 = minX;
                z3 = z4 = maxX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1f = u2f = 16.0f - u1;
                u3f = u4f = 16.0f - u2;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            case NORTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = maxY;
                y2 = y3 = minY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1f = u2f = 16.0f - u2;
                u3f = u4f = 16.0f - u1;
                v1f = v4f = 16.0f - v2;
                v2f = v3f = 16.0f - v1;
                break;
            }
            case SOUTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1f = u2f = u2;
                u3f = u4f = u1;
                v1f = v4f = 16.0f - v1;
                v2f = v3f = 16.0f - v2;
                break;
            }
            default: {
                return this;
            }
        }
        float rPrev = this.r;
        float gPrev = this.g;
        float bPrev = this.b;
        float aPrev = this.a;
        this.applyColorMultiplier(face);
        this.setNormal(face.func_82601_c(), face.func_96559_d(), face.func_82599_e());
        this.addScaledVertexWithUV(x1, y1, z1, icon, u1f, v1f);
        this.addScaledVertexWithUV(x2, y2, z2, icon, u2f, v2f);
        this.addScaledVertexWithUV(x3, y3, z3, icon, u3f, v3f);
        this.addScaledVertexWithUV(x4, y4, z4, icon, u4f, v4f);
        return this.setColorRGBA(rPrev, gPrev, bPrev, aPrev);
    }

    @Override
    public TessellatorAbstractBase drawScaledFaceDouble(float minX, float minY, float maxX, float maxY, Direction face, float offset) {
        if (face == null) {
            return this;
        }
        Direction opposite = face.func_176734_d();
        this.drawScaledFace(minX, minY, maxX, maxY, face, offset);
        this.drawScaledFace(minX, minY, maxX, maxY, opposite, offset);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledFaceDouble(float minX, float minY, float maxX, float maxY, Direction face, float offset, float u1, float v1, float u2, float v2) {
        if (face == null) {
            return this;
        }
        Direction opposite = face.func_176734_d();
        this.drawScaledFace(minX, minY, maxX, maxY, face, offset, u1, v1, u2, v2);
        this.drawScaledFace(minX, minY, maxX, maxY, opposite, offset, u1, v1, u2, v2);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledFaceDouble(float minX, float minY, float maxX, float maxY, Direction face, TextureAtlasSprite icon, float offset) {
        if (face == null) {
            return this;
        }
        Direction opposite = face.func_176734_d();
        this.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset);
        this.drawScaledFace(minX, minY, maxX, maxY, opposite, icon, offset);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledFaceDouble(float minX, float minY, float maxX, float maxY, Direction face, TextureAtlasSprite icon, float offset, float u1, float v1, float u2, float v2) {
        if (face == null) {
            return this;
        }
        Direction opposite = face.func_176734_d();
        this.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset, u1, v1, u2, v2);
        this.drawScaledFace(minX, minY, maxX, maxY, opposite, icon, offset, u1, v1, u2, v2);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledPrism(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.drawScaledFace(minX, minZ, maxX, maxZ, Direction.DOWN, minY);
        this.drawScaledFace(minX, minZ, maxX, maxZ, Direction.UP, maxY);
        this.drawScaledFace(minX, minY, maxX, maxY, Direction.NORTH, minZ);
        this.drawScaledFace(minX, minY, maxX, maxY, Direction.SOUTH, maxZ);
        this.drawScaledFace(minZ, minY, maxZ, maxY, Direction.WEST, minX);
        this.drawScaledFace(minZ, minY, maxZ, maxY, Direction.EAST, maxX);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledPrism(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, TextureAtlasSprite icon) {
        this.drawScaledFace(minX, minZ, maxX, maxZ, Direction.DOWN, icon, minY);
        this.drawScaledFace(minX, minZ, maxX, maxZ, Direction.UP, icon, maxY);
        this.drawScaledFace(minX, minY, maxX, maxY, Direction.NORTH, icon, minZ);
        this.drawScaledFace(minX, minY, maxX, maxY, Direction.SOUTH, icon, maxZ);
        this.drawScaledFace(minZ, minY, maxZ, maxY, Direction.WEST, icon, minX);
        this.drawScaledFace(minZ, minY, maxZ, maxY, Direction.EAST, icon, maxX);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledCylinder(float x, float y, float z, float r, float h, float vMax, int quads) {
        this.drawScaledCylinderOutside(x, y, z, r, h, vMax, quads);
        this.drawScaledCylinderInside(x, y, z, r, h, vMax, quads);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledCylinder(float x, float y, float z, float r, float h, TextureAtlasSprite texture, float vMax, int quads) {
        this.drawScaledCylinderOutside(x, y, z, r, h, texture, vMax, quads);
        this.drawScaledCylinderInside(x, y, z, r, h, texture, vMax, quads);
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledCylinderOutside(float x, float y, float z, float r, float h, float vMax, int quads) {
        float prevX = x + r;
        float prevZ = z;
        float prevU = 0.0f;
        for (int i = 0; i < quads; ++i) {
            double angle = (double)((i + 1) % quads * 2) * Math.PI / (double)quads;
            float newX = (float)((double)r * Math.cos(angle)) + x;
            float newZ = (float)((double)r * Math.sin(angle)) + z;
            float newU = 16.0f * (float)(i + 1) / (float)quads;
            this.addScaledVertexWithUV(prevX, y, prevZ, prevU, vMax);
            this.addScaledVertexWithUV(prevX, y + h, prevZ, prevU, 0.0f);
            this.addScaledVertexWithUV(newX, y + h, newZ, newU, 0.0f);
            this.addScaledVertexWithUV(newX, y, newZ, newU, vMax);
            prevX = newX;
            prevZ = newZ;
            prevU = newU;
        }
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledCylinderOutside(float x, float y, float z, float r, float h, TextureAtlasSprite texture, float vMax, int quads) {
        float prevX = x + r;
        float prevZ = z;
        float prevU = 0.0f;
        for (int i = 0; i < quads; ++i) {
            double angle = (double)((i + 1) % quads * 2) * Math.PI / (double)quads;
            float newX = (float)((double)r * Math.cos(angle)) + x;
            float newZ = (float)((double)r * Math.sin(angle)) + z;
            float newU = 16.0f * (float)(i + 1) / (float)quads;
            this.addScaledVertexWithUV(prevX, y, prevZ, texture, prevU, vMax);
            this.addScaledVertexWithUV(prevX, y + h, prevZ, texture, prevU, 0.0f);
            this.addScaledVertexWithUV(newX, y + h, newZ, texture, newU, 0.0f);
            this.addScaledVertexWithUV(newX, y, newZ, texture, newU, vMax);
            prevX = newX;
            prevZ = newZ;
            prevU = newU;
        }
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledCylinderInside(float x, float y, float z, float r, float h, float vMax, int quads) {
        float prevX = x + r;
        float prevZ = z;
        float prevU = 0.0f;
        for (int i = 0; i < quads; ++i) {
            double angle = (double)((i + 1) % quads * 2) * Math.PI / (double)quads;
            float newX = (float)((double)r * Math.cos(angle)) + x;
            float newZ = (float)((double)r * Math.sin(angle)) + z;
            float newU = 16.0f * (float)(i + 1) / (float)quads;
            this.addScaledVertexWithUV(prevX, y, prevZ, prevU, vMax);
            this.addScaledVertexWithUV(newX, y, newZ, newU, vMax);
            this.addScaledVertexWithUV(newX, y + h, newZ, newU, 0.0f);
            this.addScaledVertexWithUV(prevX, y + h, prevZ, prevU, 0.0f);
            prevX = newX;
            prevZ = newZ;
            prevU = newU;
        }
        return this;
    }

    @Override
    public TessellatorAbstractBase drawScaledCylinderInside(float x, float y, float z, float r, float h, TextureAtlasSprite texture, float vMax, int quads) {
        float prevX = x + r;
        float prevZ = z;
        float prevU = 0.0f;
        for (int i = 0; i < quads; ++i) {
            double angle = (double)((i + 1) % quads * 2) * Math.PI / (double)quads;
            float newX = (float)((double)r * Math.cos(angle)) + x;
            float newZ = (float)((double)r * Math.sin(angle)) + z;
            float newU = 16.0f * (float)(i + 1) / (float)quads;
            this.addScaledVertexWithUV(prevX, y, prevZ, texture, prevU, vMax);
            this.addScaledVertexWithUV(newX, y, newZ, texture, newU, vMax);
            this.addScaledVertexWithUV(newX, y + h, newZ, texture, newU, 0.0f);
            this.addScaledVertexWithUV(prevX, y + h, prevZ, texture, prevU, 0.0f);
            prevX = newX;
            prevZ = newZ;
            prevU = newU;
        }
        return this;
    }

    @Override
    public TessellatorAbstractBase translate(BlockPos pos) {
        this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return this;
    }

    @Override
    public TessellatorAbstractBase translate(float x, float y, float z) {
        this.manipulateMatrixStack(stack -> stack.func_227861_a_((double)x, (double)y, (double)z));
        return this;
    }

    @Override
    public TessellatorAbstractBase rotate(float angle, float x, float y, float z) {
        return this.rotate(new Quaternion(new Vector3f(x, y, z), angle, true));
    }

    @Override
    public TessellatorAbstractBase rotate(Quaternion quaternion) {
        this.manipulateMatrixStack(stack -> stack.func_227863_a_(quaternion));
        return this;
    }

    @Override
    public TessellatorAbstractBase scale(float x, float y, float z) {
        this.manipulateMatrixStack(stack -> stack.func_227862_a_(x, y, z));
        return this;
    }

    @Override
    public TessellatorAbstractBase applyTransformation(Matrix4f matrix) {
        this.manipulateMatrixStack(stack -> {
            stack.func_227866_c_().func_227870_a_().func_226595_a_(matrix);
            stack.func_227866_c_().func_227872_b_().func_226118_b_(new Matrix3f(matrix));
        });
        return this;
    }

    @Override
    public TextureAtlasSprite getIcon(RenderMaterial source) {
        if (source != null) {
            return (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(source);
        }
        return this.getMissingSprite();
    }

    @Override
    public ITessellator.Face getFace() {
        return this.face;
    }

    @Override
    public TessellatorAbstractBase setFace(@Nonnull ITessellator.Face face) {
        this.face = face;
        if (this.getNormal() == ITessellator.Defaults.NORMAL) {
            this.setNormal(this.getFace().getNormal());
        }
        return this;
    }

    @Override
    public TessellatorAbstractBase setNormal(float x, float y, float z) {
        this.normal.func_195905_a(x, y, z);
        return this;
    }

    @Override
    public TessellatorAbstractBase setNormal(Vector3f vec) {
        this.normal = vec;
        return this;
    }

    @Override
    public Vector3f getNormal() {
        return this.normal;
    }

    @Override
    public int getColor() {
        return (int)(this.r * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f);
    }

    @Override
    public TessellatorAbstractBase setColorRGB(Vector3f color) {
        return this.setColorRGB(color.func_195899_a(), color.func_195900_b(), color.func_195902_c());
    }

    @Override
    public TessellatorAbstractBase setColorRGB(float red, float green, float blue) {
        return this.setColorRGBA(red, green, blue, 1.0f);
    }

    @Override
    public TessellatorAbstractBase setColorRGBA(float red, float green, float blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
        return this;
    }

    @Override
    public TessellatorAbstractBase setAlpha(float alpha) {
        this.a = alpha;
        return this;
    }

    @Override
    public float getRed() {
        return this.r;
    }

    @Override
    public float getGreen() {
        return this.g;
    }

    @Override
    public float getBlue() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.a;
    }

    @Override
    public TessellatorAbstractBase setBrightness(int value) {
        this.l = value;
        return this;
    }

    @Override
    public int getBrightness() {
        return this.l;
    }

    @Override
    public TessellatorAbstractBase setOverlay(int value) {
        this.o = value;
        return this;
    }

    @Override
    public int getOverlay() {
        return this.o;
    }

    @Override
    public TessellatorAbstractBase setTintIndex(int index) {
        this.tintIndex = index;
        return this;
    }

    @Override
    public int getTintIndex() {
        return this.tintIndex;
    }

    @Override
    public TessellatorAbstractBase setApplyDiffuseLighting(boolean value) {
        this.applyDiffuseLighting = value;
        return this;
    }

    @Override
    public boolean getApplyDiffuseLighting() {
        return this.applyDiffuseLighting;
    }

    protected abstract void applyColorMultiplier(Direction var1);

    @Override
    public final TessellatorAbstractBase transform(Vector4f pos) {
        pos.func_229372_a_(this.getCurrentMatrix());
        return this;
    }

    public final BakedQuad transformQuads(BakedQuad quad) {
        return this.getCachedQuadTransformer().processOne(quad);
    }

    public final List<BakedQuad> transformQuads(List<BakedQuad> quad) {
        return this.getCachedQuadTransformer().processMany(quad);
    }

    public final void transformUnpackedVertexDataElement(VertexFormatElement.Usage type, float[] data) {
        switch (type) {
            case POSITION: 
            case NORMAL: {
                Vector4f temp = new Vector4f(data[0], data[1], data[2], 1.0f);
                temp.func_229372_a_(this.getCurrentMatrix());
                data[0] = temp.func_195910_a();
                data[1] = temp.func_195913_b();
                data[2] = temp.func_195914_c();
                break;
            }
            case COLOR: {
                data[0] = this.getRed();
                data[1] = this.getGreen();
                data[2] = this.getBlue();
                data[3] = this.getAlpha();
            }
        }
    }
}

