/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility.debug;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.utility.debug.DebugMode;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class DebugModeFeedback
extends DebugMode {
    @Override
    public String debugName() {
        return "feedback";
    }

    @Override
    public void debugActionBlockClicked(ItemStack stack, ItemUseContext context) {
        this.getDebugData(context.func_195991_k(), context.func_195995_a(), l -> {
            InfinityLib.instance.getLogger().debug((String)l, new Object[0]);
            context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent(l), Util.field_240973_b_);
        });
    }

    @Override
    public void debugActionClicked(ItemStack stack, World world, PlayerEntity player, Hand hand) {
    }

    @Override
    public void debugActionEntityClicked(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
    }

    private void getDebugData(World world, BlockPos pos, Consumer<String> consumer) {
        boolean remote = world.func_201670_d();
        TileEntity tile = world.func_175625_s(pos);
        consumer.accept("------------------");
        consumer.accept(remote ? "client" : "server debug info:");
        consumer.accept("------------------");
        consumer.accept("Clicked block at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")");
        if (tile instanceof IDebuggable) {
            IDebuggable debuggable = (IDebuggable)tile;
            if (remote) {
                debuggable.addClientDebugInfo(consumer);
            } else {
                debuggable.addServerDebugInfo(consumer);
            }
        } else {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            consumer.accept("Block: " + block);
            consumer.accept("State: " + state);
        }
        consumer.accept(" ");
    }
}

