/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.darkhax.bookshelf.block.DisplayableBlockState;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RendererBotanyPot
extends TileEntityRenderer<TileEntityBotanyPot> {
    private static final Direction[] SOIL_SIDES = new Direction[]{Direction.UP};
    private static final Direction[] CROP_SIDES = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public RendererBotanyPot(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityBotanyPot tile, float partial, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        if (tile.getSoil() != null && BotanyPots.CLIENT_CONFIG.shouldRenderSoil()) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(0.625f, 0.384f, 0.625f);
            matrix.func_227861_a_(0.3, 0.01, 0.3);
            tile.getSoil().getRenderState().render(tile.func_145831_w(), tile.func_174877_v(), matrix, buffer, light, overlay, SOIL_SIDES);
            matrix.func_227865_b_();
        }
        if (tile.getCrop() != null && BotanyPots.CLIENT_CONFIG.shouldRenderCrop()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.4, 0.5);
            if (BotanyPots.CLIENT_CONFIG.shouldDoGrowthAnimation()) {
                float partialOffset = tile.getCurrentGrowthTicks() < tile.getTotalGrowthTicks() ? partial : 0.0f;
                float progressScale = 0.25f + ((float)tile.getCurrentGrowthTicks() + partialOffset) / (float)tile.getTotalGrowthTicks() * 0.75f;
                float growth = MathHelper.func_76131_a((float)(progressScale * 0.625f), (float)0.0f, (float)1.0f);
                matrix.func_227862_a_(growth, growth, growth);
            }
            matrix.func_227861_a_(-0.5, 0.0, -0.5);
            DisplayableBlockState[] cropStates = tile.getCrop().getDisplayState();
            for (int i = 0; i < cropStates.length; ++i) {
                matrix.func_227861_a_(0.0, (double)i, 0.0);
                cropStates[i].render(tile.func_145831_w(), tile.func_174877_v(), matrix, buffer, light, overlay, CROP_SIDES);
                matrix.func_227861_a_(0.0, (double)(-i), 0.0);
            }
            matrix.func_227865_b_();
        }
    }
}

