/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.darkhax.bookshelf.util.InventoryUtils;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.api.events.BotanyPotHarvestedEvent;
import net.darkhax.botanypots.api.events.BotanyPotTickEvent;
import net.darkhax.botanypots.api.events.PotGrowCropEvent;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.network.BreakEffectsMessage;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityBotanyPot
extends TileEntityBasicTickable {
    private static ItemStackHandler DUMMY_INV = new ItemStackHandler(0);
    @Nullable
    private SoilInfo soil;
    private ItemStack soilStack = ItemStack.field_190927_a;
    @Nullable
    private CropInfo crop;
    private ItemStack cropStack = ItemStack.field_190927_a;
    private int totalGrowthTicks;
    private int currentGrowthTicks;
    private int autoHarvestCooldown;
    private ChunkPos chunkPos;
    private List<ItemStack> dropsCache = null;

    public TileEntityBotanyPot() {
        super(BotanyPots.instance.getContent().tileBotanyPot);
    }

    public boolean canSetSoil(@Nullable SoilInfo newSoil) {
        return newSoil == null || this.getSoil() == null;
    }

    public void setSoil(@Nullable SoilInfo newSoil, ItemStack stack) {
        this.soil = newSoil;
        this.soilStack = stack;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
            this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
    }

    public boolean canSetCrop(@Nullable CropInfo newCrop) {
        return newCrop == null || this.getSoil() != null && this.getCrop() == null;
    }

    public void setCrop(@Nullable CropInfo newCrop, ItemStack stack) {
        this.crop = newCrop;
        this.cropStack = stack;
        this.resetGrowthTime();
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
        }
    }

    @Nullable
    public SoilInfo getSoil() {
        return this.soil;
    }

    @Nullable
    public CropInfo getCrop() {
        return this.crop;
    }

    public int getTotalGrowthTicks() {
        return this.totalGrowthTicks;
    }

    public int getCurrentGrowthTicks() {
        return this.currentGrowthTicks;
    }

    public boolean canHarvest() {
        return this.crop != null && this.getTotalGrowthTicks() > 0 && this.getCurrentGrowthTicks() >= this.getTotalGrowthTicks();
    }

    public void resetGrowthTime() {
        this.totalGrowthTicks = BotanyPotHelper.getRequiredGrowthTicks(this.getCrop(), this.getSoil());
        this.currentGrowthTicks = 0;
        if (this.soil != null) {
            this.soil = BotanyPotHelper.getSoil(this.soil.func_199560_c());
            if (this.soil == null) {
                this.crop = null;
            }
        }
        if (this.crop != null) {
            this.crop = BotanyPotHelper.getCrop(this.crop.func_199560_c());
        }
        this.autoHarvestCooldown = 5;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
        }
    }

    public void addGrowth(int ticksToGrow) {
        this.currentGrowthTicks += ticksToGrow;
        if (this.currentGrowthTicks > this.totalGrowthTicks) {
            this.currentGrowthTicks = this.totalGrowthTicks;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync(false);
        }
    }

    public float getGrowthPercent() {
        if (this.totalGrowthTicks == -1 || this.currentGrowthTicks == -1) {
            return 0.0f;
        }
        return (float)this.currentGrowthTicks / (float)this.totalGrowthTicks;
    }

    public void onTileTick() {
        MinecraftForge.EVENT_BUS.post((Event)new BotanyPotTickEvent.Pre(this));
        if (this.hasSoilAndCrop()) {
            if (this.isDoneGrowing()) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                this.attemptAutoHarvest();
            } else {
                PotGrowCropEvent.Pre growCropEvent = new PotGrowCropEvent.Pre(this, 1);
                if (!MinecraftForge.EVENT_BUS.post((Event)growCropEvent)) {
                    this.currentGrowthTicks += growCropEvent.getCurrentAmount();
                    MinecraftForge.EVENT_BUS.post((Event)new PotGrowCropEvent.Post(this, growCropEvent.getCurrentAmount()));
                }
            }
        } else if (this.totalGrowthTicks != -1 || this.currentGrowthTicks != 0) {
            this.resetGrowthTime();
        }
        MinecraftForge.EVENT_BUS.post((Event)new BotanyPotTickEvent.Post(this));
    }

    public boolean hasSoilAndCrop() {
        return this.soil != null && this.crop != null;
    }

    public boolean isDoneGrowing() {
        return this.hasSoilAndCrop() && this.totalGrowthTicks > 0 && this.currentGrowthTicks >= this.totalGrowthTicks;
    }

    private void attemptAutoHarvest() {
        if (MinecraftForge.EVENT_BUS.post((Event)new BotanyPotHarvestedEvent.Pre(this, null))) {
            return;
        }
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockBotanyPot && ((BlockBotanyPot)block).isHopper()) {
            if (this.autoHarvestCooldown > 0) {
                --this.autoHarvestCooldown;
                return;
            }
            IItemHandler inventory = InventoryUtils.getInventory((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP);
            if (inventory != EmptyHandler.INSTANCE && !this.field_145850_b.field_72995_K) {
                boolean didAutoHarvest = false;
                List<ItemStack> drops = this.getDrops();
                block0: for (ItemStack item : drops) {
                    for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                        if (!inventory.isItemValid(slot, item) || inventory.insertItem(slot, item, true).func_190916_E() == item.func_190916_E()) continue;
                        inventory.insertItem(slot, item, false);
                        didAutoHarvest = true;
                        continue block0;
                    }
                }
                if (didAutoHarvest || drops.isEmpty()) {
                    this.onCropHarvest();
                    this.resetGrowthTime();
                    this.dropsCache = null;
                    MinecraftForge.EVENT_BUS.post((Event)new BotanyPotHarvestedEvent.Post(this, null));
                }
            }
        }
    }

    public void onCropHarvest() {
        IChunk chunk;
        if (this.hasSoilAndCrop() && (chunk = this.field_145850_b.func_217349_x(this.field_174879_c)) instanceof Chunk) {
            BotanyPots.NETWORK.sendToChunk((Chunk)chunk, (Object)new BreakEffectsMessage(this.field_174879_c, this.crop.getDisplayState()[0].getState()));
        }
        MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(this.field_145850_b, this.field_174879_c, this.getState(), this.getState()));
    }

    public void serialize(CompoundNBT dataTag) {
        if (this.soil != null) {
            dataTag.func_74778_a("Soil", this.soil.func_199560_c().toString());
            if (this.crop != null) {
                dataTag.func_74778_a("Crop", this.crop.func_199560_c().toString());
                dataTag.func_74768_a("GrowthTicks", this.currentGrowthTicks);
            }
        }
        dataTag.func_218657_a("CropStack", (INBT)this.cropStack.serializeNBT());
        dataTag.func_218657_a("SoilStack", (INBT)this.soilStack.serializeNBT());
    }

    public void deserialize(CompoundNBT dataTag) {
        this.soil = null;
        this.crop = null;
        if (dataTag.func_74764_b("CropStack")) {
            this.cropStack = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("CropStack"));
        }
        if (dataTag.func_74764_b("SoilStack")) {
            this.soilStack = ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("SoilStack"));
        }
        if (dataTag.func_74764_b("Soil")) {
            String rawSoilId = dataTag.func_74779_i("Soil");
            ResourceLocation soilId = ResourceLocation.func_208304_a((String)rawSoilId);
            if (soilId != null) {
                SoilInfo foundSoil = BotanyPotHelper.getSoil(soilId);
                if (foundSoil != null) {
                    this.soil = foundSoil;
                    if (dataTag.func_74764_b("Crop")) {
                        String rawCropId = dataTag.func_74779_i("Crop");
                        ResourceLocation cropId = ResourceLocation.func_208304_a((String)rawCropId);
                        if (cropId != null) {
                            CropInfo cropInfo = BotanyPotHelper.getCrop(cropId);
                            if (cropInfo != null) {
                                this.crop = cropInfo;
                                this.currentGrowthTicks = dataTag.func_74762_e("GrowthTicks");
                                this.totalGrowthTicks = this.crop.getGrowthTicksForSoil(this.soil);
                            } else {
                                BotanyPots.LOGGER.error("Botany Pot at {} had a crop of type {} but that crop does not exist. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                            }
                        } else {
                            BotanyPots.LOGGER.error("Botany Pot at {} has an invalid crop Id of {}. The crop will be discarded.", (Object)this.field_174879_c, (Object)rawCropId);
                        }
                    }
                } else {
                    BotanyPots.LOGGER.error("Botany Pot at {} had a soil of type {} which no longer exists. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
                }
            } else {
                BotanyPots.LOGGER.error("Botany Pot at {} has invalid soil type {}. Soil and crop will be discarded.", (Object)this.field_174879_c, (Object)rawSoilId);
            }
        }
    }

    public ItemStack getSoilStack() {
        return this.soilStack;
    }

    public ItemStack getCropStack() {
        return this.cropStack;
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.field_174879_c);
        }
        return this.chunkPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return BotanyPots.CLIENT_CONFIG.getRenderDistance();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == Direction.DOWN) {
            return LazyOptional.of(() -> DUMMY_INV).cast();
        }
        return super.getCapability(cap, side);
    }

    private List<ItemStack> getDrops() {
        if (this.dropsCache == null) {
            BotanyPotHarvestedEvent.LootGenerated event = new BotanyPotHarvestedEvent.LootGenerated(this, null, (List<ItemStack>)BotanyPotHelper.generateDrop(this.field_145850_b.field_73012_v, this.getCrop()));
            this.dropsCache = !MinecraftForge.EVENT_BUS.post((Event)event) ? event.getDrops() : NonNullList.func_191196_a();
        }
        return this.dropsCache;
    }
}

