/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.crop;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class HarvestEntry {
    private final float chance;
    private final ItemStack item;
    private final int minRolls;
    private final int maxRolls;

    public HarvestEntry(float chance, ItemStack item, int minRolls, int maxRolls) {
        this.chance = chance;
        this.item = item;
        this.minRolls = minRolls;
        this.maxRolls = maxRolls;
        if (minRolls < 0 || maxRolls < 0) {
            throw new IllegalArgumentException("Rolls must not be negative!");
        }
        if (minRolls > maxRolls) {
            throw new IllegalArgumentException("Min rolls must not be greater than max rolls!");
        }
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getMinRolls() {
        return this.minRolls;
    }

    public int getMaxRolls() {
        return this.maxRolls;
    }

    public static HarvestEntry deserialize(JsonObject json) {
        float chance = JSONUtils.func_151217_k((JsonObject)json, (String)"chance");
        ItemStack item = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("output"));
        int minRolls = JSONUtils.func_151203_m((JsonObject)json, (String)"minRolls");
        int maxRolls = JSONUtils.func_151203_m((JsonObject)json, (String)"maxRolls");
        return new HarvestEntry(chance, item, minRolls, maxRolls);
    }

    public static HarvestEntry deserialize(PacketBuffer buf) {
        float chance = buf.readFloat();
        ItemStack item = buf.func_150791_c();
        int min = buf.readInt();
        int max = buf.readInt();
        return new HarvestEntry(chance, item, min, max);
    }

    public static void serialize(PacketBuffer buffer, HarvestEntry info) {
        buffer.writeFloat(info.getChance());
        buffer.func_150788_a(info.getItem());
        buffer.writeInt(info.getMinRolls());
        buffer.writeInt(info.getMaxRolls());
    }
}

