/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking.transformers;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@FunctionalInterface
public interface PacketSink {
    public static PacketSink ofPlayer(ServerPlayerEntity player) {
        return packet -> Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_71135_a.func_147359_a(packet);
    }

    public static PacketSink ofPlayers(Iterable<? extends ServerPlayerEntity> players) {
        return packet -> {
            for (ServerPlayerEntity player : players) {
                Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").field_71135_a.func_147359_a(packet);
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PacketSink client() {
        return packet -> {
            if (Minecraft.func_71410_x().func_147114_u() == null) {
                throw new IllegalStateException("Unable to send packet to the server while not in game!");
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a(packet);
        };
    }

    public void accept(IPacket<?> var1);
}

