/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class WateringCanItem
extends BaseItem {
    private static final Map<String, Long> THROTTLES = new HashMap<String, Long>();
    protected final int range;
    protected final double chance;

    public WateringCanItem(Function<Item.Properties, Item.Properties> properties) {
        this(3, 0.25, properties);
    }

    public WateringCanItem(int range, double chance, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_200917_a(1)));
        this.range = range;
        this.chance = chance;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)false);
            items.add((Object)stack);
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockState state;
        ItemStack stack = player.func_184586_b(hand);
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BlockRayTraceResult trace = WateringCanItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BlockPos pos = trace.func_216350_a();
        Direction direction = trace.func_216354_b();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos.func_177972_a(direction), direction, stack) && (state = world.func_180495_p(pos)).func_185904_a() == Material.field_151586_h) {
            NBTHelper.setString((ItemStack)stack, (String)"ID", (String)UUID.randomUUID().toString());
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)true);
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        Direction direction;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (!player.func_175151_a(pos.func_177972_a(direction = context.func_196000_l()), direction, stack)) {
            return ActionResultType.FAIL;
        }
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return ActionResultType.PASS;
        }
        return this.doWater(stack, world, player, pos, direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            tooltip.add((ITextComponent)ModTooltips.FILLED.build());
        } else {
            tooltip.add((ITextComponent)ModTooltips.EMPTY.build());
        }
    }

    protected ActionResultType doWater(ItemStack stack, World world, PlayerEntity player, BlockPos pos, Direction direction) {
        if (player == null) {
            return ActionResultType.FAIL;
        }
        if (!player.func_175151_a(pos.func_177972_a(direction), direction, stack)) {
            return ActionResultType.FAIL;
        }
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return ActionResultType.PASS;
        }
        if (!((Boolean)ModConfigs.FAKE_PLAYER_WATERING.get()).booleanValue() && player instanceof FakePlayer) {
            return ActionResultType.PASS;
        }
        if (!world.func_201670_d()) {
            String id = WateringCanItem.getID(stack);
            long throttle = THROTTLES.getOrDefault(id, 0L);
            if (world.func_82737_E() - throttle < WateringCanItem.getThrottleTicks(player)) {
                return ActionResultType.PASS;
            }
            THROTTLES.put(id, world.func_82737_E());
        }
        int range = (this.range - 1) / 2;
        Stream blocks = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
        blocks.forEach(aoePos -> {
            int moisture;
            BlockState aoeState = world.func_180495_p(aoePos);
            if (aoeState.func_177230_c() instanceof FarmlandBlock && (moisture = ((Integer)aoeState.func_177229_b((Property)FarmlandBlock.field_176531_a)).intValue()) < 7) {
                world.func_180501_a(aoePos, (BlockState)aoeState.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)), 3);
            }
        });
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + world.func_201674_k().nextFloat();
                double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + world.func_201674_k().nextFloat();
                BlockState state = world.func_180495_p(pos);
                if (state.func_200132_m() || state.func_177230_c() instanceof FarmlandBlock) {
                    d1 += 0.3;
                }
                world.func_195594_a((IParticleData)ParticleTypes.field_197600_K, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        if (!world.func_201670_d() && Math.random() <= this.chance) {
            blocks = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
            blocks.forEach(aoePos -> {
                BlockState state = world.func_180495_p(aoePos);
                Block plantBlock = state.func_177230_c();
                if (plantBlock instanceof IGrowable || plantBlock instanceof IPlantable || plantBlock == Blocks.field_150391_bh || plantBlock == Blocks.field_185766_cS) {
                    state.func_227034_b_((ServerWorld)world, aoePos, field_77697_d);
                }
            });
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    private static String getID(ItemStack stack) {
        if (!NBTHelper.hasKey((ItemStack)stack, (String)"ID")) {
            NBTHelper.setString((ItemStack)stack, (String)"ID", (String)UUID.randomUUID().toString());
        }
        return NBTHelper.getString((ItemStack)stack, (String)"ID");
    }

    private static long getThrottleTicks(PlayerEntity player) {
        return player instanceof FakePlayer ? 10L : 5L;
    }
}

