/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.decorativeblocks.DecoBlocksCompatRegistry;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkPlugin;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class RopeKnotBlock
extends MimicBlock
implements IWaterLoggable {
    private final Map<BlockState, VoxelShape> SHAPES_MAP = new HashMap<BlockState, VoxelShape>();
    private final Map<BlockState, VoxelShape> COLLISION_SHAPES_MAP = new HashMap<BlockState, VoxelShape>();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    public static final EnumProperty<BlockProperties.PostType> POST_TYPE = BlockProperties.POST_TYPE;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    protected static final Map<Direction, BooleanProperty> FENCE_PROPERTY = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(d -> ((Direction)d.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    protected static final Map<Direction, EnumProperty<WallHeight>> WALL_PROPERTY = ImmutableMap.of((Object)Direction.NORTH, (Object)WallBlock.field_235613_c_, (Object)Direction.SOUTH, (Object)WallBlock.field_235614_d_, (Object)Direction.WEST, (Object)WallBlock.field_235615_e_, (Object)Direction.EAST, (Object)WallBlock.field_235612_b_);

    public RopeKnotBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.makeShapes();
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.Y)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(POST_TYPE, (Comparable)((Object)BlockProperties.PostType.POST))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, POST_TYPE, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RopeKnotBlockTile();
    }

    public boolean func_208619_r() {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            try {
                return ((RopeKnotBlockTile)te).getShape();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.func_220053_a(state, world, pos, context);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.SHAPES_MAP.getOrDefault(state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), VoxelShapes.func_197868_b());
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.SHAPES_MAP.getOrDefault(state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), VoxelShapes.func_197868_b());
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            try {
                return ((RopeKnotBlockTile)te).getCollisionShape();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.func_220071_b(state, world, pos, context);
    }

    protected void makeShapes() {
        VoxelShape down = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.func_208617_a((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.func_208617_a((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        for (BlockState state : this.field_176227_L.func_177619_a()) {
            VoxelShape c;
            VoxelShape v;
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) continue;
            int w = ((BlockProperties.PostType)((Object)state.func_177229_b(POST_TYPE))).getWidth();
            int o = (16 - w) / 2;
            switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                default: {
                    v = Block.func_208617_a((double)o, (double)0.0, (double)o, (double)(o + w), (double)16.0, (double)(o + w));
                    c = Block.func_208617_a((double)o, (double)0.0, (double)o, (double)(o + w), (double)24.0, (double)(o + w));
                    break;
                }
                case X: {
                    c = v = Block.func_208617_a((double)0.0, (double)o, (double)o, (double)16.0, (double)(o + w), (double)(o + w));
                    break;
                }
                case Z: {
                    c = v = Block.func_208617_a((double)o, (double)o, (double)0.0, (double)(o + w), (double)(o + w), (double)16.0);
                }
            }
            if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)up);
            }
            if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)north);
            }
            if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)south);
            }
            if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)west);
            }
            if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)east);
            }
            c = VoxelShapes.func_197872_a((VoxelShape)c, (VoxelShape)v);
            c = c.func_197753_c();
            v = v.func_197753_c();
            boolean flag = true;
            for (VoxelShape existing : this.SHAPES_MAP.values()) {
                if (!existing.equals(v)) continue;
                this.SHAPES_MAP.put(state, existing);
                flag = false;
                break;
            }
            if (flag) {
                this.SHAPES_MAP.put(state, v);
            }
            boolean flag2 = true;
            for (VoxelShape existing : this.COLLISION_SHAPES_MAP.values()) {
                if (!existing.equals(c)) continue;
                this.COLLISION_SHAPES_MAP.put(state, existing);
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            this.COLLISION_SHAPES_MAP.put(state, c);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        BlockState newState = (BlockState)state.func_206870_a((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(RopeBlock.shouldConnectToFace(state, facingState, facingPos, facing, (IWorldReader)world)));
        TileEntity te = world.func_175625_s(currentPos);
        if (te instanceof RopeKnotBlockTile) {
            BlockState newFacing;
            TileEntity te2;
            IBlockHolder tile = (IBlockHolder)te;
            BlockState oldHeld = tile.getHeldBlock();
            RopeKnotBlockTile otherTile = null;
            if (facingState.func_177230_c().func_235332_a_((Block)ModRegistry.ROPE_KNOT.get()) && (te2 = world.func_175625_s(facingPos)) instanceof RopeKnotBlockTile) {
                otherTile = (RopeKnotBlockTile)te2;
                facingState = otherTile.getHeldBlock();
            }
            BlockState newHeld = null;
            if (CompatHandler.quark) {
                newHeld = QuarkPlugin.updateWoodPostShape(oldHeld, facing, facingState);
            }
            if (newHeld == null) {
                newHeld = oldHeld.func_196956_a(facing, facingState, world, currentPos, facingPos);
            }
            if ((newFacing = facingState.func_196956_a(facing.func_176734_d(), newHeld, world, facingPos, currentPos)) != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.func_70296_d();
                } else {
                    world.func_180501_a(facingPos, newFacing, 2);
                }
            }
            BlockProperties.PostType type = RopeKnotBlock.getPostType(newHeld);
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
                te.func_70296_d();
            }
            if (newState != state) {
                ((RopeKnotBlockTile)te).recalculateShapes(newState);
            }
            if (type != null) {
                newState = (BlockState)newState.func_206870_a(POST_TYPE, (Comparable)((Object)type));
            }
        }
        return newState;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && fluidstate.func_206882_g() == 8;
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ShearsItem) {
            TileEntity te;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModRegistry.ROPE_ITEM.get()));
                world.func_184133_a(null, pos, SoundEvents.field_232843_op_, SoundCategory.PLAYERS, 0.8f, 1.3f);
                world.func_180501_a(pos, ((IBlockHolder)te).getHeldBlock(), 3);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            BlockState mimic = ((IBlockHolder)te).getHeldBlock();
            return mimic.func_177230_c().getPickBlock(state, target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Nullable
    public static BlockProperties.PostType getPostType(BlockState state) {
        BlockProperties.PostType type = null;
        if (state.func_235714_a_(ModTags.POSTS)) {
            type = BlockProperties.PostType.POST;
        } else if (state.func_235714_a_(ModTags.PALISADES) || CompatHandler.deco_blocks && DecoBlocksCompatRegistry.isPalisade(state)) {
            type = BlockProperties.PostType.PALISADE;
        } else if (state.func_235714_a_(ModTags.WALLS)) {
            type = state.func_177230_c() instanceof WallBlock && !((Boolean)state.func_177229_b((Property)WallBlock.field_176256_a)).booleanValue() ? BlockProperties.PostType.PALISADE : BlockProperties.PostType.WALL;
        } else if (state.func_235714_a_(ModTags.BEAMS)) {
            type = state.func_235901_b_((Property)BlockStateProperties.field_208174_a) && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208174_a) != false ? null : BlockProperties.PostType.BEAM;
        }
        return type;
    }

    @Nullable
    public static BlockState convertToRopeKnot(BlockProperties.PostType type, BlockState state, World world, BlockPos pos) {
        Direction.Axis axis = Direction.Axis.Y;
        if (state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
            axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
        }
        BlockState newState = (BlockState)((BlockState)((Block)ModRegistry.ROPE_KNOT.get()).func_176223_P().func_206870_a(AXIS, (Comparable)axis)).func_206870_a(POST_TYPE, (Comparable)((Object)type));
        if (!world.func_180501_a(pos, newState = Block.func_199770_b((BlockState)newState, (IWorld)world, (BlockPos)pos), 0)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            ((IBlockHolder)te).setHeldBlock(state);
            te.func_70296_d();
        }
        newState.func_235734_a_((IWorld)world, pos, 10);
        return newState;
    }
}

